/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 渠道商户信息查询 request
 *
 * @author
 * @version JlOpenMerchAccessMerchChannelInfoQueryRequest.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenMerchAccessMerchChannelInfoQueryRequest extends JlBizRequest {

    private static final long serialVersionUID = -19061634204662340L;
    /**
     * 商户号，最大长度为15
     * （必填）
     */
    @Length(max = 15, message = "merchNo长度不能超过15")
    @NotBlank(message = "商户号不能为空")
    private String merchNo;
}