/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 账单下载 request
 *
 * @author
 * @version JlOpenBillDownloadQueryRequest.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenBillDownloadQueryRequest extends JlBizRequest {

    private static final long serialVersionUID = 2583077295003674752L;
    /**
     * 账单类型
     * (必填)
     */
    @NotBlank(message = "billType不能为空")
    @Length(max = 2, message = "billType长度不能超过2")
    private String billType;

    /**
     * 账单日期. yyyyMMdd
     * (必填)
     */
    @Length(max = 8, message = "dt长度不能超过8")
    private String dt;
}