package com.fshows.apienum;

import com.fshows.request.JlOpenMerchAccessDeviceAddRequest;
import com.fshows.request.JlOpenMerchAccessMerchChannelInfoQueryRequest;
import com.fshows.request.JlWechatPayAuthBindRequest;
import com.fshows.response.JlOpenMerchAccessDeviceAddResponse;
import com.fshows.response.JlOpenMerchAccessMerchChannelInfoQueryResponse;
import com.fshows.response.JlWechatPayAuthBindResponse;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;


/**
 * 嘉联商户相关API
 *
 * @author
 * @version JlpayMerchantApiDefinitionEnum.java, v 0.1 2025-01-08 17:28
 */
public enum JlpayMerchantApiDefinitionEnum implements IApiDefinition {

    OPEN_MERCH_ACCESS_MERCH_CHANNEL_INFO_QUERY(
            "渠道商户信息查询",
            "/open/merch/access/merch-channel-info/query",
            "1.0.0",
            "MERCHANT",
            JlOpenMerchAccessMerchChannelInfoQueryRequest.class,
            JlOpenMerchAccessMerchChannelInfoQueryResponse.class
    ),
    OPEN_MERCH_ACCESS_DEVICE_ADD(
            "终端加机",
            "/open/merch/access/device/add",
            "1.0.0",
            "MERCHANT",
            JlOpenMerchAccessDeviceAddRequest.class,
            JlOpenMerchAccessDeviceAddResponse.class
    ),
    WECHAT_PAY_AUTH_BIND(
            "绑定支付目录",
            "/open/trans/authbind",
            "1.0.0",
            "MERCHANT",
            JlWechatPayAuthBindRequest.class,
            JlWechatPayAuthBindResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;

    /**
     * 接口版本
     */
    private String version;

    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    /**
     * 接口类型：
     * MERCHANT - 商户接口
     * TRADE  -  交易接口
     * COMMON  - 通用接口
     */
    private String interfaceType;


    JlpayMerchantApiDefinitionEnum(String name,
                                   String apiSubURI,
                                   String version,
                                   String interfaceType,
                                   Class requestClass,
                                   Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}