/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.hxb;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.hxb.apienum.HxbpayTradeApiEnum;
import com.fshows.hxb.request.HxbpayBaseReq;
import com.fshows.hxb.request.HxbpayBizReq;
import com.fshows.hxb.response.HxbpayBaseRes;
import com.fshows.hxb.response.HxbpayBizRes;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.http.PostHttpRequestHandler;
import com.fshows.sdk.core.client.component.serializable.JsonSerializableHandler;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.kayak.enve.EnvApplication;
import com.kayak.sign.KKAES2;
import com.kayak.sign.SignVer;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HxbTradeApiClinet
extends AbstractApiClient<HxbpayBizReq, HxbpayBaseRes, HxbpayTradeApiEnum> {
    private static final Logger log = LoggerFactory.getLogger(HxbTradeApiClinet.class);
    protected ISerializableHandler paramSerializable = new JsonSerializableHandler();
    protected IHttpRequestHandler httpRequestHandler = new PostHttpRequestHandler();
    private EnvApplication envApplication = new EnvApplication();

    public HxbTradeApiClinet(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
        String cert = this.envApplication.getCert(apiClientConfig.getPayCompanyPublicKey());
        apiClientConfig.setPayCompanyPublicKey(cert);
    }

    protected HxbpayBaseRes doExecute(HxbpayBizReq request, HxbpayTradeApiEnum iApiDefinition, DefaultClientConfigModel merchantConfigModel) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        LogUtil.info((Logger)log, (String)"{} >> \u6267\u884c\u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), iApiDefinition, request});
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, merchantConfigModel);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            apiResponseModel = this.httpRequest(apiRequestModel, requestContext);
            Object requestBody = ObjectUtils.defaultIfNull((Object)apiRequestModel.getRequestBody(), (Object)apiRequestModel.getRequestForm());
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u5bc6\u6587] >> url={}, method={}, request={}, response={}, cost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, requestBody, apiResponseModel.getResponseBody(), System.currentTimeMillis() - beginTime});
            HxbpayBaseRes baseRes = this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u660e\u6587] >> url={}, method={}, request={}, response={}, cost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, JSONObject.toJSONString((Object)request), JSONObject.toJSONString((Object)baseRes), System.currentTimeMillis() - beginTime});
            return baseRes;
        }
        catch (FsApiException e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw e;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw new FsApiException(e.getMessage(), (Throwable)e);
        }
    }

    protected ApiRequestModel buildApiRequestModel(HxbpayBizReq request, DefaultRequestContext context) {
        String bodyJson = "";
        try {
            DefaultClientConfigModel configModel = context.getApiClientConfig();
            request.setMerchantId(configModel.getAgentId());
            request.setPcsDate(DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
            ApiRequestModel apiRequestModel = new ApiRequestModel();
            apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL() + context.getIApiDefinition().getApiURI());
            bodyJson = JSONObject.toJSONString((Object)request);
            String retSigned = SignVer.signJson((String)bodyJson, (String)configModel.getFubeiPrivateKey(), (String)configModel.getPassword());
            String sRetBody = this.encode(bodyJson);
            apiRequestModel.setRequestSign(retSigned);
            HxbpayBaseReq baseReq = new HxbpayBaseReq();
            baseReq.setAppid(configModel.getAppId());
            baseReq.setSignature(retSigned);
            baseReq.setVersion(context.getIApiDefinition().getVersion());
            baseReq.setBody(sRetBody);
            apiRequestModel.setRequest((IRequestDefinition)baseReq);
            String requestBody = this.paramSerializable.serializeObject(apiRequestModel, context);
            apiRequestModel.setRequestBody(requestBody);
            return apiRequestModel;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u534e\u590f\u5f02\u5e38 >> iApiDefinition={}, request={}, bodyJson={}", (Throwable)e, (Object[])new Object[]{this.getClientInfo().getClientDesc(), context.getIApiDefinition(), request, bodyJson});
            throw new RuntimeException(e);
        }
    }

    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientCode("hxb-sdk");
        clientInfoModel.setClientName("\u534e\u590f\u94f6\u884c");
        return clientInfoModel;
    }

    protected HxbpayBaseRes buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        String body = null;
        try {
            String responseBody = apiResponseModel.getResponseBody();
            JSONObject resJson = JSONObject.parseObject((String)responseBody);
            String bodyCiphertext = (String)resJson.remove((Object)"body");
            DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
            HxbpayBaseRes hxbpayBaseRes = (HxbpayBaseRes)resJson.toJavaObject(HxbpayBaseRes.class);
            body = this.decode(bodyCiphertext);
            log.info(" \u89e3\u5bc6\u4e4b\u540e\u7684\u62a5\u6587 >> body={}", (Object)body);
            if (StringUtils.isNotBlank((CharSequence)body)) {
                hxbpayBaseRes.setBody((HxbpayBizRes)JSONObject.parseObject((String)body, (Class)requestContext.getIApiDefinition().getResponseClass()));
            }
            return hxbpayBaseRes;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u534e\u590f\u54cd\u5e94\u5f02\u5e38 >> iApiDefinition={}, request={}, \u89e3\u5bc6\u540e\u7684body={}", (Throwable)e, (Object[])new Object[]{this.getClientInfo().getClientDesc(), requestContext.getIApiDefinition(), apiRequestModel.getRequest(), body});
            throw new RuntimeException(e);
        }
    }

    public String decode(String ciphertext) {
        byte[] decryption = this.envApplication.openEnvelope(this.apiClientConfig.getFubeiPrivateKey(), this.apiClientConfig.getPassword(), ciphertext);
        return StrUtil.str((byte[])decryption, (String)"utf-8");
    }

    public String encode(String plaintext) {
        return this.envApplication.makeEnvelope(this.apiClientConfig.getPayCompanyPublicKey(), KKAES2.AES, StrUtil.bytes((CharSequence)plaintext, (String)"UTF-8"));
    }

    public boolean verifySign(String body, String signed) {
        try {
            return SignVer.verifyJson((String)body, (String)signed, (String)this.apiClientConfig.getPayCompanyPublicKey());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        return this.httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }

    public HxbpayBaseRes execute(HxbpayBizReq request, HxbpayTradeApiEnum apiDefinition) throws FsApiException {
        return (HxbpayBaseRes)this.doExecute(request, apiDefinition);
    }

    public HxbpayBaseRes execute(HxbpayBizReq request, HxbpayTradeApiEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }
}

