/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.hxb.response.merchant;

import com.fshows.hxb.response.HxbpayBizRes;
import lombok.Data;

/**
 * @author wangqilei
 * @version HxbTerminalRegisterQueryRes.java, v 0.1 2024-04-10 2:41 PM wangqilei
 */
@Data
public class HxbTerminalRegisterQueryRes extends HxbpayBizRes {
    private static final long serialVersionUID = 6599898020514611622L;

    /**
     * 系统产生的唯一流水号
     * (选填)
     */
    private String systemNo;

    /**
     * 系统交易代码
     * (选填)
     */
    private String tranTrace;

    /**
     * 业务处理结果代码
     * (选填)
     */
    private String respCode;

    /**
     * 业务处理结果描述
     * (选填)
     */
    private String respMsg;

    /**
     * 终端在银联端的状态，如Q:启用，T:冻结
     * (选填)
     */
    private String termNo;

    /**
     * 终端在华夏银行的状态，0-停用，1-启用
     * (选填)
     */
    private String termStatus;

    /**
     * 终端在银联端的当前状态，Q:启用，T:冻结
     * (选填)
     */
    private String unionRegistResult;

    /**
     * 银联注册状态更新日期
     * (选填)
     */
    private String unionUpdateDate;

    /**
     * 银联注册失败的具体原因
     * (选填)
     */
    private String unionFailReason;

    /**
     * 终端在微信端的当前状态，Q:启用，T:冻结
     * (选填)
     */
    private String wechatRegistResult;

    /**
     * 微信注册状态更新日期
     * (选填)
     */
    private String wechatUpdateDate;

    /**
     * 微信注册失败的具体原因
     * (选填)
     */
    private String wechatFailReason;

    /**
     * 终端在支付宝端的当前状态，Q:启用，T:冻结
     * (选填)
     */
    private String aliRegistResult;

    /**
     * 支付宝注册状态更新日期
     * (选填)
     */
    private String aliUpdateDate;

    /**
     * 支付宝注册失败的具体原因
     * (选填)
     */
    private String aliFailReason;
}