/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.hxb.request.merchant;

import com.fshows.hxb.request.HxbpayBizReq;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * @author zfq
 * @version HxbUploadFileReq.java, v 0.1 2024-07-25 17:49 buhao
 */
@Data
public class HxbUploadFileReq extends HxbpayBizReq {
    private static final long serialVersionUID = -253397635584733798L;
    /**
     * 系统流水号
     */
    private String systemNo;
    /**
     * 系统交易码
     */
    @NotBlank(message = "tranTrace不能为空")
    private String tranTrace;
    /**
     * 进件id
     */
    @NotBlank(message = "id不能为空")
    private String id;

    /**
     * 附件类型
     * 必须上传的附件类型：
     * 01:法人身份证正面
     * 02:法人身份证反面
     * 03:营业执照
     * 07:商户门头照片
     * 08:商户申请表
     * CR221260修改：
     * 非小微商户“03营业执照”必传，小微商户“03营业执照”非必传；“08商户申请表”取消必传。
     */
    @NotBlank(message = "fileType不能为空")
    private String fileType;

    /**
     * 附件信息
     * base64格式文件信息
     */
    @NotBlank(message = "img不能为空")
    private String img;
}