/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.hxb.request.merchant;

import com.fshows.hxb.request.HxbpayBizReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * @author wangqilei
 * @version HxbTerminalRegisterReq.java, v 0.1 2024-04-10 2:41 PM wangqilei
 */
@Data
public class HxbTerminalRegisterReq extends HxbpayBizReq {
    private static final long serialVersionUID = -6265423857902112446L;

    /**
     * 系统内部流水号，非必填
     * (选填)
     */
    private String systemNo;

    /**
     * 系统交易码，如PAY008，必填
     * (必填)
     */
    private String tranTrace;

    /**
     * 一级服务商编号，服务商模式下必填，商户模式无需上送
     * (特殊必填)
     */
    @Length(max = 20, message = "parentServerorgno长度不能超过20")
    private String parentServerorgno;

    /**
     * 二级服务商机构编码，服务商模式下校验商户与二级服务商关联关系，商户模式无需上送
     * (特殊必填)
     */
    @Length(max = 20, message = "serverOrgNo长度不能超过20")
    private String serverOrgNo;

    /**
     * 华夏商户编号，必填，HX商户编号或304商户编号
     * (选填)
     */
    @Length(max = 15, message = "payMerchantNo长度不能超过15")
    private String payMerchantNo;

    /**
     * 终端编号，总行分配，商户生成，确保唯一，如'12345678'
     * (选填)
     */
    @Length(max = 8, message = "termNo长度不能超过8")
    private String termNo;

    /**
     * 终端类型，终端注销时非必填，例如'20'代表条码支付受理终端
     * (选填)
     */
    @Length(max = 2, message = "termType长度不能超过2")
    private String termType;

    /**
     * 终端序列号，终端类型为20时必填，不超过50个字符
     * (选填)
     */
    @Length(max = 50, message = "posSerialNo长度不能超过50")
    private String posSerialNo;

    /**
     * 终端布放地址，终端注销时非必填，至少6个汉字
     * (选填)
     */
    @Length(max = 60, message = "deployAddress长度不能超过60")
    private String deployAddress;

    /**
     * 地址编号，终端注销时非必填，如省份编号
     * (选填)
     */
    @Length(max = 6, message = "deployAddressProvince长度不能超过6")
    private String deployAddressProvince;

    /**
     * 地址编号，终端注销时非必填，如城市编号
     * (选填)
     */
    @Length(max = 6, message = "deployAddressCity长度不能超过6")
    private String deployAddressCity;

    /**
     * 地址编号，终端注销时非必填，如区县编号
     * (选填)
     */
    @Length(max = 6, message = "deployAddressArea长度不能超过6")
    private String deployAddressArea;

    /**
     * 银联注册状态，I:新增，U:修改，D:注销
     * (选填)
     */
    @Length(max = 1, message = "unionRegistStatus长度不能超过1")
    private String unionRegistStatus;

    /**
     * 微信注册状态，I:新增，U:修改，D:注销
     * (选填)
     */
    @Length(max = 1, message = "wechatRegistStatus长度不能超过1")
    private String wechatRegistStatus;

    /**
     * 支付宝注册状态，I:新增，U:修改，D:注销
     * (选填)
     */
    @Length(max = 1, message = "aliRegistStatus长度不能超过1")
    private String aliRegistStatus;

    /**
     * 终端生产企业名称，非必输，不超过60个字符
     * (选填)
     */
    @Length(max = 60, message = "termProducerName长度不能超过60")
    private String termProducerName;

    /**
     * 终端产品型号，非必输，不超过20个字符
     * (选填)
     */
    @Length(max = 20, message = "termProductModel长度不能超过20")
    private String termProductModel;

    /**
     * 正整数，终端允许交易范围
     * (选填)
     */
    private Integer moveRange;
}