/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.hxb.request.merchant;

import com.fshows.hxb.request.HxbpayBizReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * @author wangqilei
 * @version HxbTerminalRegisterQueryReq.java, v 0.1 2024-04-10 2:41 PM wangqilei
 */
@Data
public class HxbTerminalRegisterQueryReq extends HxbpayBizReq {
    private static final long serialVersionUID = 2825354730659030171L;

    /**
     * 系统内部流水号
     * (选填)
     */
    private String systemNo;

    /**
     * 系统交易码 PAY009
     * (必填)
     */
    private String tranTrace;

    /**
     * 终端编号，英文字母区分大小写，必填（示例：PAYOUT001）
     * (特殊必填)
     */
    @Length(max = 8, message = "termNo长度不能超过8")
    private String termNo;
}