/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.hxb.request.merchant;

import com.fshows.hxb.request.HxbpayBizReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

/**
 * @author zfq
 * @version HxbMerchantAuditQueryRequest.java, v 0.1 2024-07-25 16:44 buhao
 */
@Data
public class HxbMerchantAuditQueryReq extends HxbpayBizReq {
    private static final long serialVersionUID = 7306558035911505283L;

    /**
     * 系统流水号
     */
    private String systemNo;

    /**
     * 系统交易码
     */
    @NotBlank(message = "tranTrace不能为空")
    private String tranTrace;


    /**
     * 进件id
     */
    @NotBlank(message = "id不能为空")
    @Length(max = 32, message = "id长度不合法")
    private String id;

}