/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.response.trade;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.hxb.response.HxbpayBizRes;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 银联前台模式订单推送
 *
 * @author
 * @version HxbUniouOrderCreateRes.java, v 0.1 2024-02-28 17:38:21
 */
@Data
public class HxbUniouOrderCreateRes extends HxbpayBizRes {

    private static final long serialVersionUID = -2213838555941197491L;


    /**
     * 返回信息
     * 返回信息，详见数据字典“返回信息”
     * (选填)
     */
    private String respMsg;

    /**
     * 支付状态响应码
     * 支付状态响应码，OO:成功, WI:需要轮询, FL：失败，返回码为“000000”时返回左侧字段
     * (选填)
     */
    private String statusCode;

    /**
     * 支付状态响应信息
     * 支付状态响应信息
     * (选填)
     */
    private String statusMsg;

    /**
     * 重定向地址
     * 收单机构在支付下单时，银联返回重定向地址，收单机构将URL地址通过302返回给浏览器
     * (选填)
     */
    private String redirectUrl;

    /**
     * 商户通道交易订单号
     * 银行系统生成，发往银联的交易订单号
     * (选填)
     */
    private String channelNo;

}