/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.hxb.response.merchant;

import com.fshows.hxb.response.HxbpayBizRes;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

/**
 * @author zhengfangquan
 * @version Test.java, v 0.1 2024-7-25 下午5:13 zhengfangquan
 */
@Data
public class HxbMerchantAuditQueryRes extends HxbpayBizRes {

    private static final long serialVersionUID = -6276657151081533030L;
    /**
     * 系统流水号
     */
    private String systemNo;

    /**
     * 系统交易码
     */
    private String tranTrace;

    /**
     * 流程状态
     * 1待提交
     * 2处理中
     * 3已完成
     * 5退回
     */
    @NotBlank(message = "bpmStatus不能为空")
    private String bpmStatus;

    /**
     * 商户编码
     */
    private String merchantNo;

    /**
     * 结算账户类型
     *
     * “本行对公户”时，“对公”
     * “本行对私户”时，“对私”
     * “本行结算卡”时，“对公”
     * “他行对公户”时，“对公”
     * “他行对私户”时，“对私”
     */
    private String accountType;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 结算账号/卡号
     */
    private String settlementOrTransferAccount;

    /**
     * 开户银行名称
     */
    private String orgBankName;

    /**
     * 微信商户识别码
     */
    private String wechatId;

    /**
     * 支付宝商户编码
     */
    private String alipayMerchantNo;

    /**
     * 商户编号（HX开头的）
     */
    private String payMerchantNo;

    /**
     * 商户APPID
     */
    private String merchantAppid;

    /**
     * 数字货币商户编号
     */
    private String dcMerchantNo;
    ;

    /**
     * 数字货币POS终端编号
     */
    private String dcPosNo;

    /**
     * 当前环节
     */
    private String processTaskName;

    /**
     * 服务商商户ID
     */
    private String serverMerchantId;

    /**
     * 备注
     */
    private String reMarks;


}