/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.request.trade;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.hxb.request.HxbpayBizReq;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 退款
 *
 * @author
 * @version HxbRefundCreateReq.java, v 0.1 2024-02-14 20:59:19
 */
@Data
public class HxbRefundCreateReq extends HxbpayBizReq {

    private static final long serialVersionUID = -2213838555829065333L;


    /**
     * 商户退款流水号
     * 合作方自定义流水号，唯一标识一笔交易（建议根据当前系统日期和时间加随机序列生成，确保唯一）
     * (选填)
     */
    @Length(max = 32, message = "refundOrderNo长度不能超过32")
    private String refundOrderNo;

    /**
     * 原交易流水号
     * 需要退款的原交易流水号
     * (选填)
     */
    @Length(max = 32, message = "origOrderNo长度不能超过32")
    private String origOrderNo;

    /**
     * 退款金额
     * 单位为元，两位小数，该金额不能大于订单金额
     * (选填)
     */
    @Length(max = 10, message = "amount长度不能超过10")
    private String amount;

    /**
     * 原交易日期
     * yyyyMMdd
     * (选填)
     */
    @Length(max = 8, message = "orgPcsDate长度不能超过8")
    private String orgPcsDate;

    /**
     * 网络地址（终端IP）
     * Ipv4格式：xx.xx.xx.xx Ipv6格式： xx:xx:xx:xx:xx:xx:xx:xx (注:1.Ipv6需转换为16进制;)
     * (选填)
     */
    private String occurAdd;

    /**
     * 交易设备GPS
     * 字段说明见3.1.12。 1.与网络地址（终端IP）二选一必输,。 2.终端类型为10，GPS必输;
     * (选填)
     */
    @Length(max = 32, message = "GPS长度不能超过32")
    private String GPS;

    /**
     * 退款原因
     * 填写退款描述，最多64个汉字。数币专用。 不要使用`~!@#$%^&+=|{}';'<>/?~！#￥%&+|{}‘；”“'。？等特殊字符
     * (选填)
     */
    @Length(max = 128, message = "refundReason长度不能超过128")
    private String refundReason;

    /**
     * 终端编号
     * 上送规则如下: 1.上送终端编号为已在我行系统注册的且终端状态启用，上送终端编号应与商户编号相互匹配。 2.条码交易允许跨终端退款，即A终端发生的交易，可以通过B终端发起退款
     * (选填)
     */
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

}