/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.response.trade;

import com.fshows.hxb.response.trade.item.HxbWxPayInfoItem;
import com.fshows.hxb.response.HxbpayBizRes;
import lombok.Data;

/**
 * 微信统一下单
 *
 * @author
 * @version HxbWxJsApiPayRes.java, v 0.1 2024-02-14 20:50:30
 */
@Data
public class HxbWxJsApiPayRes extends HxbpayBizRes {

    private static final long serialVersionUID = -2213838555576011067L;


    /**
     * 返回信息
     * 详见数据字典“返回信息”
     * (选填)
     */
    private String respMsg;

    /**
     * 支付状态响应码
     * OO:成功 WI:需要轮询 FL：失败
     * (选填)
     */
    private String statusCode;

    /**
     * 支付状态响应信息
     * 
     * (选填)
     */
    private String statusMsg;

    /**
     * 商户流水号
     * 返回码为“000000”时返回左侧字段。
     * (选填)
     */
    private String orderNo;

    /**
     * 微信支付信息
     * 包含js调用需要的信息，详情参见要素说明
     * (选填)
     */
    private HxbWxPayInfoItem wxPayInfo;

    /**
     * 商户号
     * 银联商户号
     * (选填)
     */
    private String merId;

    /**
     * 公众账号ID
     * 微信返回的appid
     * (选填)
     */
    private String appid;

    /**
     * 子公众账号ID
     * 微信返回的子商户公众账号ID
     * (选填)
     */
    private String subAppid;

    /**
     * 商户通道交易订单号
     * 银行系统生成，发往微信支付宝银联通道的通道交易订单号
     * (选填)
     */
    private String channelNo;

    /**
     * 商户号
     * 微信支付分配的商户号
     * (选填)
     */
    private String mchId;

}