/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.response.trade;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.hxb.response.HxbpayBizRes;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 退款
 *
 * @author
 * @version HxbRefundCreateRes.java, v 0.1 2024-02-14 20:59:19
 */
@Data
public class HxbRefundCreateRes extends HxbpayBizRes {

    private static final long serialVersionUID = -2213838555269510228L;


    /**
     * 返回信息
     * 详见数据字典“返回信息”
     * (选填)
     */
    private String respMsg;

    /**
     * 平台流水号
     * 微信、支付宝、银联、数研所等平台返回的退款订单号。 返回码为“000000”时返回左侧字段。
     * (选填)
     */
    private String tradeNo;

    /**
     * 成功时间
     * yyyyMMddHHmmss
     * (选填)
     */
    private String successTime;

    /**
     * 商户通道退款订单号
     * 银行系统生成，发往微信支付宝银联、数研所通道的通道退款交易订单号
     * (选填)
     */
    private String channelOrderNo;

    /**
     * 退款金额
     * 本次退款金额。
     * (选填)
     */
    private String amount;

    /**
     * 原商户通道交易订单号
     * 需要退款的原商户通道交易订单号
     * (选填)
     */
    private String origChannelNo;

    /**
     * 银联-商品优惠明细内容
     * 详情参见要素说明
     * (选填)
     */
    private String ylDctDetail;

    /**
     * 银联-优惠信息
     * 详情参见要素说明
     * (选填)
     */
    private String ylCouponInfo;

    /**
     * 微信-退款金额
     * 微信-去掉非充值代金券退款金额后的退款金额，退款金额=申请退款金额-非充值代金券退款金额，退款金额<=申请退款金额
     * (选填)
     */
    private String wxSettlementRefundFee;

    /**
     * 微信-现金退款金额
     * 微信-现金退款金额，单位为元
     * (选填)
     */
    private String wxCashRefundFee;

    /**
     * 微信-代金券退款总金额
     * 微信-代金券退款金额<=退款金额，退款金额-代金券或立减优惠退款金额为现金
     * (选填)
     */
    private String wxCouponRefundFee;

    /**
     * 微信-优惠退款详情
     * 详情参见要素说明
     * (选填)
     */
    private String wxRefundDetail;

    /**
     * 支付宝-买家退款金额
     * 支付宝-本次退款金额中买家退款金额
     * (选填)
     */
    private String aliPresentRefundBuyerAmount;

    /**
     * 支付宝-平台优惠退款金额
     * 支付宝-本次退款金额中平台优惠退款金额
     * (选填)
     */
    private String aliPresentRefundDiscountAmount;

    /**
     * 支付宝-商家优惠退款金额
     * 支付宝-本次退款金额中商家优惠退款金额
     * (选填)
     */
    private String aliPresentRefundMdiscountAmount;

}