package com.fshows.hxb.apienum;

import com.fshows.hxb.contant.HxbpayContant;
import com.fshows.hxb.request.merchant.*;
import com.fshows.hxb.request.trade.HxbAlipayJsApiPayReq;
import com.fshows.hxb.request.trade.HxbOrderQueryReq;
import com.fshows.hxb.request.trade.HxbPreOrderCreateReq;
import com.fshows.hxb.request.trade.HxbRefundCreateReq;
import com.fshows.hxb.request.trade.HxbRevokedCreateReq;
import com.fshows.hxb.request.trade.HxbScanCardCreateReq;
import com.fshows.hxb.request.trade.HxbTradeBillDownloadReq;
import com.fshows.hxb.request.trade.HxbUniouOrderCreateReq;
import com.fshows.hxb.request.trade.HxbUniouUserIdQueryReq;
import com.fshows.hxb.request.trade.HxbWxJsApiPayReq;
import com.fshows.hxb.response.merchant.HxbTerminalRegisterQueryRes;
import com.fshows.hxb.response.merchant.HxbTerminalRegisterRes;
import com.fshows.hxb.response.merchant.HxbWxConfigInfoRes;
import com.fshows.hxb.response.merchant.HxbWxConfigRes;
import com.fshows.hxb.response.trade.HxbAlipayJsApiPayRes;
import com.fshows.hxb.response.trade.HxbOrderQueryRes;
import com.fshows.hxb.response.trade.HxbPreOrderCreateRes;
import com.fshows.hxb.response.trade.HxbRefundCreateRes;
import com.fshows.hxb.response.trade.HxbRevokedCreateRes;
import com.fshows.hxb.response.trade.HxbScanCardCreateRes;
import com.fshows.hxb.response.trade.HxbTradeBillDownloadRes;
import com.fshows.hxb.response.trade.HxbUniouOrderCreateRes;
import com.fshows.hxb.response.trade.HxbUniouUserIdQueryRes;
import com.fshows.hxb.response.trade.HxbWxJsApiPayRes;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;

/**
 * 华夏银行交易相关API
 *
 * @author liluqing
 * @version FuiouSettlementApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum HxbpayTradeApiEnum implements IApiDefinition {


    PRE_ORDER_CREATE(
            "主扫交易（定额码）",
            "/trans/OPC103040202000100002600",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbPreOrderCreateReq.class,
            HxbPreOrderCreateRes.class
    ),
    SCAN_CARD_CREATE(
            "被扫交易（付款码支付）",
            "/trans/OPC103040202000100002500",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbScanCardCreateReq.class,
            HxbScanCardCreateRes.class
    ),
    WX_JS_API_PAY(
            "微信公众号(小程序)支付）",
            "/trans/OPC103040202000100002800",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbWxJsApiPayReq.class,
            HxbWxJsApiPayRes.class
    ),
    ALIPAY_JS_API_PAY(
            "支付宝当面付统一下单",
            "/trans/OPC103040202000100003300",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbAlipayJsApiPayReq.class,
            HxbAlipayJsApiPayRes.class
    ),
    REFUND_CREATE(
            "退款申请发起",
            "/trans/OPC103040202000100002900",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbRefundCreateReq.class,
            HxbRefundCreateRes.class
    ),
    REVOKED_CREATE(
            "撤销交易",
            "/trans/OPC103040202000100003000",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbRevokedCreateReq.class,
            HxbRevokedCreateRes.class
    ),
    ORDER_QUERY(
            "订单查询接口",
            "/trans/OPC103040202000100003100",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbOrderQueryReq.class,
            HxbOrderQueryRes.class
    ),
    TRADE_BILL_DOWNLOAD(
            "对账文件下载",
            "/trans/OPC103040202000100003500",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbTradeBillDownloadReq.class,
            HxbTradeBillDownloadRes.class
    ),
    WX_JSAPI_PATH(
            "微信授权目录配置",
            "/mechantApiIn/wxJsapiPathConfig",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbWxJsapiConfigReq.class,
            HxbWxConfigRes.class
    ),
    WX_APPID_CONFIG(
            "微信绑定APPID配置",
            "/mechantApiIn/wxSubAppidConfig",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbWxAppIdConfigReq.class,
            HxbWxConfigRes.class
    ),
    UNIOU_USER_ID_QUERY(
            "获取银联userId",
            "/trans/OPC103040202000100004200",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbUniouUserIdQueryReq.class,
            HxbUniouUserIdQueryRes.class
    ),
    UNIOU_ORDER_CREATE(
            "银联前台模式订单推送",
            "/trans/OPC103040202000100004300",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbUniouOrderCreateReq.class,
            HxbUniouOrderCreateRes.class
    ),
    WX_CONFIG_QUERY(
            "微信配置查询",
            "/mechantApiIn/wxConfigQuery",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbWxConfigQueryReq.class,
            HxbWxConfigInfoRes.class
    ),
    TERMINAL_REGISTER(
            "终端注册",
            "/mechantApiIn/termRegist",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbTerminalRegisterReq.class,
            HxbTerminalRegisterRes.class
    ),
    TERMINAL_REGISTER_QUERY(
            "终端注册结果查询",
            "/mechantApiIn/getTermRegistResult",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbTerminalRegisterQueryReq.class,
            HxbTerminalRegisterQueryRes.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本，默认2.0
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    HxbpayTradeApiEnum(String name,
                       String apiSubURI,
                       String version,
                       Class requestClass,
                       Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}