/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.hxb.response.trade.item;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * 华夏银行微信支付信息
 *
 * @author liluqing
 * @version HxbWxPayInfoItem.java, v 0.1 2024-02-16 13:34
 */
@Data
public class HxbWxPayInfoItem implements Serializable {

    private static final long serialVersionUID = -5457693467840922806L;

    /**
     * 时间戳
     */
    @JSONField(name = "timeStamp")
    private String payTimeStamp;

    /**
     * 签名包
     */
    @JSONField(name = "package")
    private String payPackage;

    /**
     * 签名值
     */
    @JSONField(name = "paySign")
    private String paySign;

    /**
     * appid
     */
    @JSONField(name = "appId")
    private String payAppId;

    /**
     * 签名方式
     */
    @JSONField(name = "signType")
    private String paySignType;

    /**
     * 随机字符串
     */
    @JSONField(name = "nonceStr")
    private String payNonceStr;
}