/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.request.trade;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.hxb.request.HxbpayBizReq;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 对账文件下载
 *
 * @author
 * @version HxbTradeBillDownloadReq.java, v 0.1 2024-02-14 21:13:09
 */
@Data
public class HxbTradeBillDownloadReq extends HxbpayBizReq {

    private static final long serialVersionUID = -2213838555499775659L;


    /**
     * 对账日期
     * 格式：2019-01-03
     * (选填)
     */
    @Length(max = 10, message = "reconDate长度不能超过10")
    private String reconDate;

    /**
     * 文件类型
     * 不传默认下载条码交易对账文件。 0：条码支付对账文件 1：数字人民币对账文件
     * (选填)
     */
    @Length(max = 1, message = "type长度不能超过1")
    private String type;

}