/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.response.trade;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.hxb.response.HxbpayBizRes;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 获取银联userId
 *
 * @author
 * @version HxbUniouUserIdQueryRes.java, v 0.1 2024-02-28 17:21:05
 */
@Data
public class HxbUniouUserIdQueryRes extends HxbpayBizRes {

    private static final long serialVersionUID = -2213838555919645573L;


    /**
     * 返回信息
     * 返回信息，详见数据字典“返回信息”
     * (选填)
     */
    private String respMsg;

    /**
     * 用户标识
     * 用户在APP上的标识号，用来提供给收款方，并在收款方发起交易时回传给付款方
     * (选填)
     */
    private String userId;

}