/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.response.trade;

import com.fshows.hxb.response.HxbpayBizRes;
import lombok.Data;

/**
 * 交易查询
 *
 * @author
 * @version HxbOrderQueryRes.java, v 0.1 2024-02-14 21:09:43
 */
@Data
public class HxbOrderQueryRes extends HxbpayBizRes {

    private static final long serialVersionUID = -2213838555265607064L;


    /**
     * 返回信息
     * 详见数据字典“返回信息”
     * (选填)
     */
    private String respMsg;

    /**
     * 支付状态响应码
     * OO:成功 WI:需要轮询 FL：失败 返回码为“000000”时返回左侧字段。
     * (选填)
     */
    private String statusCode;

    /**
     * 支付状态响应信息
     * 
     * (选填)
     */
    private String statusMsg;

    /**
     * 支付货币类型
     * 
     * (选填)
     */
    private String currency;

    /**
     * 交易方式
     * 支付宝--ALIPAY, 银联云闪付YLPAY 微信-WXPAY ECNYPAY-数字人民币
     * (选填)
     */
    private String payMethod;

    /**
     * 交易类型
     * 1 -支付， 2-退款/撤销
     * (选填)
     */
    private String tradeType;

    /**
     * 付款银行
     * 银行类型，采用字符串类型的银行标识
     * (选填)
     */
    private String bankType;

    /**
     * 原交易流水号
     * 下游上送的交易流水号
     * (选填)
     */
    private String orderNo;

    /**
     * 平台流水号
     * 微信、支付宝、银联、数研所等平台返回的订单号
     * (选填)
     */
    private String tradeNo;

    /**
     * 商户通道交易订单号
     * 银行系统生成，发往微信支付宝银联数研所通道的通道交易订单号
     * (选填)
     */
    private String channelOrderNo;

    /**
     * 交易金额
     * tradeType为1-支付时必返
     * (选填)
     */
    private String amount;

    /**
     * 退款金额
     * tradeType为2-退款/撤销时必返
     * (选填)
     */
    private String refundAmount;

    /**
     * 付款人编号
     * 
     * (选填)
     */
    private String buyerId;

    /**
     * 支付成功时间
     * yyyyMMddHHmmss
     * (选填)
     */
    private String successTime;

    /**
     * 银联-优惠信息
     * 详情参见要素说明
     * (选填)
     */
    private String ylCouponInfo;

    /**
     * 实际付款金额
     * 消费者实际付款金额。tradeType=1时，通道返回，则返回
     * (选填)
     */
    private String userPayAmt;

    /**
     * 微信-优惠功能
     * 详情参见要素说明
     * (选填)
     */
    private String wxPromotionDetail;

    /**
     * 支付宝-费率活动标识
     * 支付宝-费率活动标识，当交易享受活动优惠费率时，返回该活动的标识； (1)蓝海活动优惠费率0，值为bluesea_1 (2)特殊行业优惠费率0，值为industry_special_00 (3)特殊行业优惠费率千一，值为industry_special_01
     * (选填)
     */
    private String chargeFlags;

    /**
     * 支付宝-优惠券信息
     * 详情参见要素说明
     * (选填)
     */
    private String aliVoucherDetailList;

    /**
     * 支付宝-商品优惠明细内容
     * 详情参见要素说明
     * (选填)
     */
    private String aliDiscountGoodsDetail;

    /**
     * 微信用户子标识
     * 微信交易子商户appid下用户唯一标识，交易成功时微信通道返回时会同步返回此信息
     * (选填)
     */
    private String subOpenId;

    /**
     * 买家在支付宝的用户id
     * 支付宝交易成功时返回例:2088101117955611
     * (选填)
     */
    private String buyerUserId;

    /**
     * 微信-退款金额
     * 微信退款交易。-去掉非充值代金券退款金额后的退款金额，退款金额=申请退款金额-非充值代金券退款金额，退款金额<=申请退款金额
     * (选填)
     */
    private String wxSettlementRefundFee;

    /**
     * 微信-现金退款金额
     * 微信退款交易。现金退款金额，单位为元
     * (选填)
     */
    private String wxCashRefundFee;

    /**
     * 微信-代金券退款总金额
     * 微信退款交易。代金券退款金额<=退款金额，退款金额-代金券或立减优惠退款金额为现金
     * (选填)
     */
    private String wxCouponRefundFee;

    /**
     * 微信-优惠退款详情
     * 详情参见要素说明
     * (选填)
     */
    private String wxRefundDetail;

    /**
     * 支付宝-买家退款金额
     * 支付宝-本次退款金额中买家退款金额
     * (选填)
     */
    private String aliPresentRefundBuyerAmount;

    /**
     * 支付宝-平台优惠退款金额
     * 支付宝-本次退款金额中平台优惠退款金额
     * (选填)
     */
    private String aliPresentRefundDiscountAmount;

    /**
     * 支付宝-商家优惠退款金额
     * 支付宝-本次退款金额中商家优惠退款金额
     * (选填)
     */
    private String aliPresentRefundMdiscountAmount;

}