/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.request.trade;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.hxb.request.HxbpayBizReq;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 交易查询
 *
 * @author
 * @version HxbOrderQueryReq.java, v 0.1 2024-02-14 21:09:43
 */
@Data
public class HxbOrderQueryReq extends HxbpayBizReq {

    private static final long serialVersionUID = -2213838555946531210L;


    /**
     * 原交易流水号
     * 需要查询的交易流水号
     * (选填)
     */
    @Length(max = 32, message = "orderNo长度不能超过32")
    private String orderNo;

    /**
     * 原交易日期
     * yyyyMMdd
     * (选填)
     */
    @Length(max = 8, message = "orgPcsDate长度不能超过8")
    private String orgPcsDate;

    /**
     * 交易类型
     * 1 -支付， 2-退款/撤销。为空时默认查询支付订单。
     * (选填)
     */
    @Length(max = 10, message = "tradeType长度不能超过10")
    private String tradeType;

    /**
     * 网络地址（终端IP）
     * Ipv4格式：xx.xx.xx.xx Ipv6格式： xx:xx:xx:xx:xx:xx:xx:xx (注:1.Ipv6需转换为16进制;)
     * (选填)
     */
    @Length(max = 40, message = "occurAdd长度不能超过40")
    private String occurAdd;

    /**
     * 交易设备GPS
     * 字段说明见3.1.12。 1.与网络地址（终端IP）二选一必输。 2.终端类型为10，GPS必输;
     * (选填)
     */
    @Length(max = 32, message = "GPS长度不能超过32")
    private String GPS;

}