/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.hxb.request.merchant;

import com.fshows.hxb.request.HxbpayBizReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * @author zhubo
 * @version HxbWxJsapiConfigReq.java, v 0.1 2024-02-20 9:57 zhubo
 */
@Data
public class HxbWxJsapiConfigReq extends HxbpayBizReq {
    private static final long serialVersionUID = 4861482732981211546L;

    /**
     * 系统流水号
     */
    private String systemNo;

    /**
     * 系统交易码
     */
    private String tranTrace;

    /**
     * 付款商户编号
     * 商户编号（HX开头的）
     */
    @Length(max = 32, message = "payMerchantNo长度不能超过32")
    private String payMerchantNo;

    /**
     * jsapi路径
     * 只支持新增，不支持修改和删除，单次交易只允许新增一个，最多5个
     */
    @Length(max = 200, message = "jsapiPath长度不能超过200")
    private String jsapiPath;
}
