/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.request.trade;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.hxb.request.HxbpayBizReq;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 支付宝订单创建
 *
 * @author
 * @version HxbAlipayJsApiPayReq.java, v 0.1 2024-02-14 20:54:49
 */
@Data
public class HxbAlipayJsApiPayReq extends HxbpayBizReq {

    private static final long serialVersionUID = -2213838555248741953L;


    /**
     * 交易金额
     * 单位为元，两位小数
     * (选填)
     */
    @Length(max = 10, message = "amount长度不能超过10")
    private String amount;

    /**
     * 订单标题
     * 即购买的商品名称，不输入系统默认商户名称
     * (选填)
     */
    @Length(max = 128, message = "subject长度不能超过128")
    private String subject;

    /**
     * 买家支付宝账号
     * 买家支付宝账号，和buyerId不能同时为空
     * (选填)
     */
    @Length(max = 100, message = "buyerLogonId长度不能超过100")
    private String buyerLogonId;

    /**
     * 买家的支付宝唯一用户号
     * 买家的支付宝唯一用户号（2088开头的16位纯数字）,和buyerLogonId不能同时为空
     * (选填)
     */
    @Length(max = 28, message = "buyerId长度不能超过28")
    private String buyerId;

    /**
     * 商户流水号
     * 字段说明见3.1.9
     * (选填)
     */
    @Length(max = 32, message = "orderNo长度不能超过32")
    private String orderNo;

    /**
     * 通知地址
     * 平台异步返回支付结果给商户的地址
     * (选填)
     */
    @Length(max = 200, message = "notifyUrl长度不能超过200")
    private String notifyUrl;

    /**
     * 支付宝-可打折金额
     * 参与优惠计算的金额。详情参见要素说明
     * (选填)
     */
    @Length(max = 10, message = "aliDiscountableAmount长度不能超过10")
    private String aliDiscountableAmount;

    /**
     * 终端类型
     * 上送规则如下: 1.参考6.3设备类型数据字典，仅支持10-条码支付受理终端、11-条码支付辅助受理终端、13-MIS 终端; 2.上送未知终端类型则拒绝交易，并且上送终端类型需与终端编号匹配。
     * (选填)
     */
    @Length(max = 2, message = "terminalType长度不能超过2")
    private String terminalType;

    /**
     * 终端序列号
     * 上送规则如下: 1.当终端类型为10时，则终端序列号必输。 2.上送终端序列号需与上送的终端编号匹配关系正确。
     * (选填)
     */
    @Length(max = 50, message = "serialNum长度不能超过50")
    private String serialNum;

    /**
     * 终端编号
     * 上送规则如下: 1.上送终端编号为已在我行系统注册的且终端状态启用，上送终端编号应与商户编号相互匹配。 2.不支持使用银行自有终端。
     * (选填)
     */
    @Length(max = 8, message = "terminalId长度不能超过8")
    private String terminalId;

    /**
     * 终端入网认证编号
     * 该编号由“中国银联标识产品企业资质认证办公室”通过入网认证的终端进行分配。 格式：5 位字符，例如P3100
     * (选填)
     */
    @Length(max = 5, message = "networkLicense长度不能超过5")
    private String networkLicense;

    /**
     * 网络地址（终端IP）
     * Ipv4格式：xx.xx.xx.xx Ipv6格式： xx:xx:xx:xx:xx:xx:xx:xx (注:1.Ipv6需转换为16进制;)
     * (选填)
     */
    @Length(max = 40, message = "occurAdd长度不能超过40")
    private String occurAdd;

    /**
     * 交易设备GPS
     * 字段说明见3.1.12。 1.与网络地址（终端IP）二选一必输,。 2.终端类型为10，GPS必输;
     * (选填)
     */
    @Length(max = 32, message = "GPS长度不能超过32")
    private String GPS;

    /**
     * 借贷标识
     * no_credit--指定不能使用信用卡支付
     * (选填)
     */
    @Length(max = 20, message = "limitPay长度不能超过20")
    private String limitPay;

    /**
     * 花呗分期数
     * 例：3 仅支持传入3,6,12，其他期数暂不支持
     * (选填)
     */
    @Length(max = 5, message = "hbFqNum长度不能超过5")
    private String hbFqNum;

    /**
     * 使用花呗分期需要卖家承担的手续费比例
     * 百分值，传入100代表100% 商家承担手续费传100，用户承担手续费传0。间联模式仅支持传0
     * (选填)
     */
    @Length(max = 3, message = "hbFqSellerPercent长度不能超过3")
    private String hbFqSellerPercent;

    /**
     * 订单有效时间
     * 单位为分钟，可上送范围：1-5区间的整数值，默认订单有效时间5分钟
     * (选填)
     */
    @Length(max = 10, message = "expireTime长度不能超过10")
    private String expireTime;

    /**
     * 未成年支付控制
     * 1：限制，即该笔订单仅限成年人支付
     * (选填)
     */
    @Length(max = 1, message = "isAdult长度不能超过1")
    private String isAdult;

}