/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.response.trade;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.hxb.response.HxbpayBizRes;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 条码支付-被扫
 *
 * @author
 * @version HxbScanCardCreateRes.java, v 0.1 2024-02-14 20:41:22
 */
@Data
public class HxbScanCardCreateRes extends HxbpayBizRes {

    private static final long serialVersionUID = -2213838555668162957L;


    /**
     * 返回信息
     * 详见数据字典“返回信息”
     * (选填)
     */
    private String respMsg;

    /**
     * 支付状态响应码
     * OO:成功 WI:需要轮询 FL：失败
     * (选填)
     */
    private String statusCode;

    /**
     * 支付状态响应信息
     * 
     * (选填)
     */
    private String statusMsg;

    /**
     * 支付货币类型
     * 返回码为“000000”时返回左侧字段
     * (选填)
     */
    private String currency;

    /**
     * 订单金额
     * 单位为元，两位小数
     * (选填)
     */
    private String amount;

    /**
     * 交易方式
     * 支付宝--ALIPAY，银联云闪付-YLPAY，微信-WXPAY，数字人民币-ECNYPAY
     * (选填)
     */
    private String payMethod;

    /**
     * 付款码
     * 
     * (选填)
     */
    private String authCode;

    /**
     * 商户流水号
     * 
     * (选填)
     */
    private String orderNo;

    /**
     * 平台流水号
     * 微信、支付宝、银联、数研所等平台返回的订单号
     * (选填)
     */
    private String tradeNo;

    /**
     * 商户通道交易订单号
     * 银行系统生成，发往微信支付宝银联、数研所通道的通道交易订单号
     * (选填)
     */
    private String channelNo;

    /**
     * 付款银行
     * 银行类型，采用字符串类型的银行标识
     * (选填)
     */
    private String bankType;

    /**
     * 付款用户
     * 付款人编号
     * (选填)
     */
    private String buyerId;

    /**
     * 支付成功时间
     * 支付成功时间，格式：yyyyMMddHHmmss
     * (选填)
     */
    private String successTime;

    /**
     * 实付金额
     * 消费者实际付款金额，通道返回，则返回
     * (选填)
     */
    private String userPayAmt;

    /**
     * 微信-优惠功能
     * 详情参见要素说明
     * (选填)
     */
    private String wxPromotionDetail;

    /**
     * 支付宝-费率活动标识
     * 支付宝-费率活动标识，当交易享受活动优惠费率时，返回该活动的标识；蓝海活动优惠费率0，值为bluesea_1，特殊行业优惠费率0，值为industry_special_00，特殊行业优惠费率千一，值为industry_special_01
     * (选填)
     */
    private String chargeFlags;

    /**
     * 支付宝-优惠券信息
     * 详情参见要素说明
     * (选填)
     */
    private String aliVoucherDetailList;

    /**
     * 支付宝-商品优惠明细内容
     * 详情参见要素说明
     * (选填)
     */
    private String aliDiscountGoodsDetail;

    /**
     * 微信用户子标识
     * 微信交易子商户appid下用户唯一标识，交易成功时微信通道返回时会同步返回此信息
     * (选填)
     */
    private String subOpenId;

    /**
     * 买家在支付宝的用户id
     * 支付宝交易成功时返回例:2088101117955611
     * (选填)
     */
    private String buyerUserId;

}