/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.response.trade;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.hxb.response.HxbpayBizRes;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 撤销
 *
 * @author
 * @version HxbRevokedCreateRes.java, v 0.1 2024-02-14 21:01:40
 */
@Data
public class HxbRevokedCreateRes extends HxbpayBizRes {

    private static final long serialVersionUID = -2213838555921156196L;


    /**
     * 返回信息
     * 详见数据字典“返回信息”
     * (选填)
     */
    private String respMsg;

    /**
     * 原商户通道交易订单号
     * 商户要撤销的原商户通道交易订单号 返回码为“000000”时返回左侧字段。
     * (选填)
     */
    private String origChannelNo;

    /**
     * 商户撤销订单时间
     * yyyyMMddHHmmss
     * (选填)
     */
    private String successTime;

    /**
     * 原订单交易金额
     * 单位为元，两位小数
     * (选填)
     */
    private String amount;

}