/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.response.trade;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.hxb.response.HxbpayBizRes;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 支付宝订单创建
 *
 * @author
 * @version HxbAlipayJsApiPayRes.java, v 0.1 2024-02-14 20:54:49
 */
@Data
public class HxbAlipayJsApiPayRes extends HxbpayBizRes {

    private static final long serialVersionUID = -2213838555679139966L;


    /**
     * 返回信息
     * 详见数据字典“返回信息”
     * (选填)
     */
    private String respMsg;

    /**
     * 商户通道交易订单号
     * 银行系统生成，发往微信支付宝银联通道的通道交易订单号 返回码为“000000”时返回左侧字段。
     * (选填)
     */
    private String channelNo;

    /**
     * 支付状态响应码
     * OO:成功 WI:需要轮询 FL：失败
     * (选填)
     */
    private String statusCode;

    /**
     * 支付状态响应信息
     * 
     * (选填)
     */
    private String statusMsg;

    /**
     * 银联交易号
     * 需注意，商户/收单机 中构页面通过JSSDK 直接调用支付宝APP 时，商户/收单需要将 银联返回的交易号去 掉前两位后再调用支付宝APP (992015042321001004720200028594) 返回码为“000000”时返回左侧字段。
     * (选填)
     */
    private String tradeNo;

}