/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.hxb.response;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import lombok.Data;

/**
 * 全局参数和业务参数嵌套请求类
 *
 * @author liluqing
 * @version NestBaseRequest.java, v 0.1 2023-12-12 15:43
 */
@Data
public class HxbpayBaseRes implements IResponseDefinition {

    private static final long serialVersionUID = -5244829912663227109L;


    /**
     * 版本号,此版接口固定值：2.0
     */
    private String version;

    /**
     * 开发者ID,P10文件签发之后分配
     */
    private String appid;

    /**
     * 签名摘要,对body进行签名作业之后获取的摘要信息
     */
    private String signature;

    /**
     * 错误描述（仅请求业务处理失败时返回）
     */
    private String msg;

    /**
     * 错误码（仅请求业务处理失败时返回）
     */
    private String status;

    /**
     * 业务参数
     */
    private HxbpayBizRes data;
}