/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.hxb.request.trade;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.hxb.request.HxbpayBizReq;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 撤销
 *
 * @author
 * @version HxbRevokedCreateReq.java, v 0.1 2024-02-14 21:01:40
 */
@Data
public class HxbRevokedCreateReq extends HxbpayBizReq {

    private static final long serialVersionUID = -2213838555543897773L;


    /**
     * 商户请求流水号
     * 合作方自定义流水号，唯一标识一笔交易（建议根据当前系统日期和时间加随机序列生成，确保唯一）
     * (选填)
     */
    @Length(max = 32, message = "orderNo长度不能超过32")
    private String orderNo;

    /**
     * 原交易流水号
     * 需要撤销的原交易流水号
     * (选填)
     */
    @Length(max = 32, message = "origOrderNo长度不能超过32")
    private String origOrderNo;

    /**
     * 原交易日期
     * yyyyMMdd
     * (选填)
     */
    @Length(max = 8, message = "orgPcsDate长度不能超过8")
    private String orgPcsDate;

    /**
     * 网络地址（终端IP）
     * Ipv4格式：xx.xx.xx.xx Ipv6格式： xx:xx:xx:xx:xx:xx:xx:xx (注:1.Ipv6需转换为16进制;)
     * (选填)
     */
    @Length(max = 40, message = "occurAdd长度不能超过40")
    private String occurAdd;

    /**
     * 交易设备GPS
     * 字段说明见3.1.12。 1.与网络地址（终端IP）二选一必输。 2.终端类型为10，GPS必输;
     * (选填)
     */
    @Length(max = 32, message = "GPS长度不能超过32")
    private String GPS;

}