/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.hxb.apienum;

import com.fshows.hxb.contant.HxbpayContant;
import com.fshows.hxb.request.merchant.HxbWxAppIdConfigReq;
import com.fshows.hxb.request.merchant.HxbWxJsapiConfigReq;
import com.fshows.hxb.response.merchant.HxbWxConfigRes;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;

/**
 * @author zhubo
 * @version HxbpayMerchantApiEnum.java, v 0.1 2024-02-20 10:23 zhubo
 */
public enum HxbpayMerchantApiEnum implements IApiDefinition {
    WX_JSAPI_PATH(
            "微信授权目录配置",
            "/wxJsapiPathConfig",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbWxJsapiConfigReq.class,
            HxbWxConfigRes.class
    ),
    WX_APPID_CONFIG(
            "微信绑定APPID配置",
            "/wxSubAppidConfig",
            HxbpayContant.DEFAULT_API_VERSION,
            HxbWxAppIdConfigReq.class,
            HxbWxConfigRes.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本，默认2.0
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    HxbpayMerchantApiEnum(String name, String apiSubURI, String version, Class requestClass, Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public <T extends IRequestDefinition> Class<T> getRequestClass() {
        return null;
    }

    @Override
    public <T extends IResponseDefinition> Class<T> getResponseClass() {
        return null;
    }
}
