/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.hxb;

import com.fshows.hxb.contant.HxbpayContant;
import com.fshows.hxb.request.HxbpayBaseReq;
import com.fshows.hxb.request.HxbpayBizReq;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.handler.IApiSignHandler;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.http.PostHttpRequestHandler;
import com.fshows.sdk.core.client.component.serializable.JsonSerializableHandler;
import com.fshows.sdk.core.client.component.signer.RsaSignHandlerImpl;
import com.fshows.sdk.core.client.tempalte.nest.apienum.NestApiDefinitionEnum;
import com.fshows.sdk.core.client.tempalte.nest.request.NestBaseRequest;
import com.fshows.sdk.core.client.tempalte.nest.request.NestBizRequest;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.hxb.apienum.HxbpayTradeApiEnum;
import com.fshows.hxb.response.HxbpayBaseRes;
import com.fshows.sdk.core.util.RequestParamUtils;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;

/**
 * 嵌套参数客户端模版
 * @author liluqing
 * @version NestTemplateApiClinet.java, v 0.1 2023-12-12 15:40
 */
@Slf4j
public class HxbTradeApiClinet extends AbstractApiClient<HxbpayBizReq, HxbpayBaseRes, HxbpayTradeApiEnum> {

    /**
     * 加签验签处理器
     */
    protected IApiSignHandler iApiSignHandler = new RsaSignHandlerImpl();

    /**
     * 序列化处理器
     */
    protected ISerializableHandler paramSerializable = new JsonSerializableHandler();

    /**
     * 请求执行器
     */
    protected IHttpRequestHandler httpRequestHandler = new PostHttpRequestHandler();

    public HxbTradeApiClinet(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
    }

    /**
     * 构建请求参数
     *
     * @param request
     * @param context
     * @return
     */
    @Override
    protected ApiRequestModel buildApiRequestModel(HxbpayBizReq request, DefaultRequestContext context) {
        // todo: 一般来说该方法需要完成以下事项
        // 1. 设置网关地址  2. 请求参数填充  3. 请求加签  4. 请求参数序列化

        // sdk客户端配置
        DefaultClientConfigModel defaultClientConfigModel = context.getApiClientConfig();

        ApiRequestModel apiRequestModel = new ApiRequestModel();
        // 设置网关地址
        apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL() + context.getIApiDefinition().getApiURI());
        // 请求加签处理
        apiRequestModel.setParamMap(RequestParamUtils.toMapObj(request, apiClientConfig.isHump(),true));
        apiRequestModel.setRequestSign(iApiSignHandler.sign(apiRequestModel, context));

        // 补充参数构建实际的请求入参
        HxbpayBaseReq baseReq = new HxbpayBaseReq();
        baseReq.setAppid(defaultClientConfigModel.getAppId());
        baseReq.setSignature(apiRequestModel.getRequestSign());
        baseReq.setVersion(HxbpayContant.DEFAULT_API_VERSION);
        baseReq.setBody(request);
        apiRequestModel.setRequest(baseReq);

        // 参数序列化
        String requestBody = paramSerializable.serializeObject(apiRequestModel, context);
        apiRequestModel.setRequestBody(requestBody);
        return apiRequestModel;
    }

    /**
     * 处理客户端信息
     *
     * @return
     */
    @Override
    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientCode("fuiou-sdk");
        clientInfoModel.setClientCode("富友分账");
        return clientInfoModel;
    }

    @Override
    protected HxbpayBaseRes buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        // todo: 一般来说该方法需要完成以下事项
        // 1.  2. 请求参数填充  3. 请求加签  4. 参数反序列化

        return null;
    }

    @Override
    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        return httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }

    @Override
    public HxbpayBaseRes execute(HxbpayBizReq request, HxbpayTradeApiEnum apiDefinition) throws FsApiException {
        return super.doExecute(request, apiDefinition);
    }

    @Override
    public HxbpayBaseRes execute(HxbpayBizReq request, HxbpayTradeApiEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return super.doExecute(request, apiDefinition, configModel);
    }

}