/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.account;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 归集授权申请接口
 *
 * @author
 * @version FuStdAddConcentrateRelationRes.java, v 0.1 2023-12-28 15:46:16
 */
@Data
public class FuStdAddConcentrateRelationRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555783807590L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 被归集商户号
     * 被归集商户在富友的唯一代码
     * (必填)
     */
    @NotBlank
    private String mchntCdConcentrate;

    /**
     * 申请号
     * 本次申请的唯一标识符
     * (必填)
     */
    @NotBlank
    private String batchNo;

    /**
     * 授权链接
     * checkType 为 2 的时候返回，特殊授权模式不返回
     * (选填)
     */
    private String checkUrl;

}