/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;

/**
 * 充值记账接口
 *
 * @author
 * @version FuStdRechargeTradeAllocateReq.java, v 0.1 2024-01-02 15:29:26
 */
@Data
public class FuStdRechargeTradeAllocateReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555388333743L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 源支付订单号
     * 富友支付参考流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "srcFasSsn长度不能超过12")
    private String srcFasSsn;

    /**
     * 源交易日期
     * YYYYMMdd
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "srcFasDate长度不能超过8")
    private String srcFasDate;

    /**
     * 用户编号
     * 分账入账方编号
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "accountIn长度不能超过30")
    private String accountIn;

    /**
     * 充值金额
     * 充值金额，单位：分
     * (必填)
     */
    @NotNull
    private Integer allocateAmt;

}