/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import com.fshows.steward.annotation.NoSign;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;

/**
 * 转账记账接口
 *
 * @author
 * @version FuStdAccountInTransferToMchntReq.java, v 0.1 2024-01-02 15:41:59
 */
@Data
public class FuStdAccountInTransferToMchntReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555430045851L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 转出用户编号
     * 
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "accountIn长度不能超过40")
    private String accountIn;

    /**
     * 转入账户:支持传入商户自有子账户，不传时默认商户主账户
     *
     * (非必填)
     */
    @NoSign
    private String transferInAccountIn;

    /**
     * 转出记账金额
     * 
     * (必填)
     */
    @NotNull
    private Integer amt;

}