/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.response.merchant;

import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author zhangmj
 * @version FuiouEquipmentBindResponse.java, v 0.1 2023-10-16 10:42 zhangmj
 */
@Data
public class FuiouEquipmentUnBindResponse extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = 4588238984524170696L;

    /**
     * 唯一流水号
     * (必填)
     */
    private String traceNo;

    /**
     * 返回码 0000：查询成功 其他返回码：失败 9999：系统异常
     * (必填)
     */
    private String retCode;

    /**
     * 返回信息
     * (必填)
     */
    private String retMsg;

    /**
     * 富友商户号
     * (必填)
     */
    private String mchntCd;

    /**
     * 变更单号
     * (选填)
     */
    private String modifyNo;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}