package com.fshows.fuiou.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouModifyCancelResponse;
import lombok.Data;

import java.io.Serializable;

@Data
public class FuiouModifyCancelRequest extends FuiouBizRequest<FuiouModifyCancelResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {
    private static final long serialVersionUID = -903891848699823219L;

    /**
     * 机构号,接入机构在富友的唯一代码
     */
    @JSONField(name = "ins_cd")
    private String insCd;

    /**
     * 唯一流水号，机构自己定义，此字段可辅助拉取报文
     */
    @JSONField(name = "trace_no")
    private String traceNo;

    /**
     * 商户号,富友分配给二级商户的商户号
     */
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 变更单号
     */
    @JSONField(name = "modify_no")
    private String modifyNo;
}
