/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouForeignCardOpenResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author mengqf
 * @version FuiouForeignCardOpenRequest.java, v 0.1 2025-05-13 17:57 mengqf
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class FuiouForeignCardOpenRequest extends FuiouBizRequest<FuiouForeignCardOpenResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {
    private static final long serialVersionUID = -7072148873059194144L;

    /**
     * 唯一流水号
     */
    private String traceNo;

    /**
     * 商户号
     */
    private String mchntCd;

    /**
     * DCC开通标识
     * 1:开通，0:不开通
     */
    private String dccFlag;

    /**
     * DCC扣率
     * dccFlag=1时，必填
     */
    private String dccSetCd;

    /**
     * EDC开通标识
     * 1:开通，0:不开通
     */
    private String edcFlag;

    /**
     * EDC扣率
     * edcFlag=1时，必填
     */
    private String edcSetCd;

    /**
     * EDC优惠扣率
     */
    private String edcSetCdSpc;

    /**
     * 商户中文名称
     */
    private String mchntName;

    /**
     * 商户中文简称
     */
    private String mchntShortname;

    /**
     * 商户英文名称
     */
    private String mchntEnName;

    /**
     * 商户英文简称
     */
    private String mchntEnShortname;

    /**
     * 商户城市（英文）
     * 例如：SHANGHAI
     */
    private String cityEnName;

    /**
     * 商户邮编
     */
    private String postalCode;

    /**
     * 商户英文地址
     */
    private String contactEnAddr;
}