/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.fgj;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.fgj.FuiouFgjApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.fgj.FuiouFgjUpdateResponse;
import com.fshows.steward.annotation.NoSign;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @author
 * @version FgjCreateRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouFgjUpdateRequest extends FuiouBizRequest<FuiouFgjUpdateResponse, FuiouFgjApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = 6946617656733530884L;
    /**
     * 唯一流水号，机构自己定义
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "traceNo长度不能超过64")
    @JSONField(name = "trace_no")
    private String traceNo;

    /**
     * 二级代理机构号
     */
    @JSONField(name = "sub_ins_cd")
    private String subInsCd;

    /**
     * 商户号
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 商户类别
     * 0: 企业、
     * 1: 个体工商户、
     * 9: 其他、
     * 2: 事业单位、
     * 6: 民办非企业单位
     */
    @JSONField(name = "license_type")
    private String licenseType;

    /**
     * 商户名称
     不能有特殊字符，仅可包含汉字、数字、字母
     (需与营业执照一致，如遇提示重复，请在后面加数字1、2...)
     */
    @Length(max = 64, message = "mchntName长度不能超过64")
    @JSONField(name = "mchnt_name")
    private String mchntName;

    /**
     * 企业名称
     */
    @Length(max = 64, message = "realName长度不能超过64")
    @JSONField(name = "real_name")
    private String realName;

    /**
     * 商户简称
     */
    @Length(max = 64, message = "mchntShortname长度不能超过64")
    @JSONField(name = "mchnt_shortname")
    private String mchntShortname;

    /**
     * 品牌名称
     */
    @Length(max = 64, message = "platNameCn长度不能超过64")
    @JSONField(name = "plat_name_cn")
    private String platNameCn;

    /**
     * 商户所在市
     */
    @Length(max = 4, message = "公司经营地址长度不能超过4")
    @JSONField(name = "city_cd")
    private String cityCd;

    /**
     * 商户所在区/县
     */
    @Length(max = 4, message = "公司经营地址长度不能超过4")
    @JSONField(name = "county_cd")
    private String countyCd;

    /**
     * 商户经营地联系地址
     */
    @Length(max = 80, message = "公司经营地址长度不能超过80")
    @JSONField(name = "contact_addr")
    private String contactAddr;

    /**
     * 注册地址
     */
    @Length(max = 80, message = "营业执照注册地址长度不能超过80")
    @JSONField(name = "lic_regis_addr")
    private String licRegisAddr;

    /**
     * 注册资金
     * 单位：万元
     */
    @Length(max = 8, message = "regisCapital长度不能超过8")
    @JSONField(name = "regis_capital")
    private String regisCapital;

    /**
     * 商户联系人
     */
    @Length(max = 15, message = "法人姓名长度不能超过15")
    @JSONField(name = "contact_person")
    private String contactPerson;

    /**
     * 商户联系人身份证号码
     */
    @Length(max = 18, message = "法人证件号码长度不能超过18")
    @JSONField(name = "contact_cert_no")
    private String contactCertNo;

    /**
     * 商户联系人身份证开始日
     */
    @Length(max = 8, message = "商户联系人身份证开始日长度不能超过8")
    @JSONField(name = "contact_cert_start_dt")
    private String contactCertStartDt;
    /**
     * 商户联系人身份证到期日
     * 长期请填20991231
     */
    @Length(max = 8, message = "商户联系人身份证到期日长度不能超过8")
    @JSONField(name = "contact_cert_expire_dt")
    private String contactCertExpireDt;

    /**
     * 商户联系人手机
     */
    @Length(max = 11, message = "法人手机号长度不能超过11")
    @JSONField(name = "contact_mobile")
    private String contactMobile;

    /**
     * 商户联系人邮箱
     */
    @Length(max = 60, message = "contactEmail长度不能超过60")
    @JSONField(name = "contact_email")
    private String contactEmail;

    /**
     * 初始账号密码发送方式
     * 1:短信
     * 2:邮件
     * 3:短信+邮件
     * 不传默认短信+邮件方式
     */
    @JSONField(name = "mx_send_type")
    private String mxSendType;

    /**
     * 年费
     * 非必传，单位分
     * 不传默认0元
     */
    @JSONField(name = "annual_fee")
    private String annualFee;

    /**
     * 对接费
     * 非必传，单位分
     * 不传默认0元
     */
    @JSONField(name = "docking_fee")
    private String dockingFee;
    /**
     * 资源包费
     * 非必传，单位分
     * 不传默认0元
     */
    @JSONField(name = "resource_package_fee")
    private String resourcePackageFee;
    /**
     * 企业执照证件类型
     * 0: 营业执照、
     * 1: 营业执照（三证合一）
     */
    @JSONField(name = "license_certif_tp")
    private String licenseCertifTp;
    /**
     * 营业执照编号
     */
    @Length(max = 28, message = "营业执照号长度不能超过28")
    @JSONField(name = "license_no")
    private String licenseNo;
    /**
     * 营业执照有效期起始日
     */
    @Length(max = 8, message = "营业执照有效期起始日长度不能超过8")
    @JSONField(name = "license_start_dt")
    private String licenseStartDt;
    /**
     * 营业执照有效期到期日
     * 长期请填20991231
     * 无有效期请填19000101
     */
    @Length(max = 8, message = "营业执照有效期到期日长度不能超过8")
    @JSONField(name = "license_expire_dt")
    private String licenseExpireDt;
    /**
     * 法人姓名
     */
    @Length(max = 15, message = "法人姓名长度不能超过15")
    @JSONField(name = "artif_nm")
    private String artifNm;
    /**
     * 法人手机号
     */
    @Length(max = 11, message = "法人手机号长度不能超过11")
    @JSONField(name = "artif_mobile")
    private String artifMobile;
    /**
     * 法人证件类型
     * 0:身份证
     * 1:护照
     * 2:通行证
     * 3:警察证
     * 4:台胞证
     */
    @JSONField(name = "artif_certif_tp")
    private String artifCertifTp;
    /**
     * 法人证件号
     */
    @Length(max = 18, message = "法人证件号码长度不能超过18")
    @JSONField(name = "certif_id")
    private String certifId;
    /**
     * 法人身份证有效期起始日
     */
    @Length(max = 8, message = "法人证件有效期长度不能超过8")
    @JSONField(name = "card_start_dt")
    private String cardStartDt;
    /**
     * 法人身份证有效期到期日
     * 长期请填20991231
     */
    @Length(max = 8, message = "法人证件有效期长度不能超过8")
    @JSONField(name = "certif_id_expire_dt")
    private String certifIdExpireDt;

    /**
     * 组织机构代码证编号
     * 执照证件类型非三证合一时，必传
     */
    @Length(max = 16, message = "zzjgzdmNo长度不能超过16")
    @JSONField(name = "zzjgzdm_no")
    private String zzjgzdmNo;
    /**
     * 税务登记证编号
     * 执照证件类型非三证合一时，必传
     */
    @Length(max = 30, message = "taxNo长度不能超过30")
    @JSONField(name = "tax_no")
    private String taxNo;
    /**
     * 结算方式
     * 01：对公清算
     * 02：对私清算
     * 04：双账户清算
     * 仅个体工商户支持对私清算
     */
    @Length(max = 2, message = "acntType长度不能超过2")
    @JSONField(name = "acnt_type")
    private String acntType;
    /**
     * 对公结算卡
     * 对公清算、双账户清算必传
     * 对公结算户名默认为企业名称
     */
    @Length(max = 40, message = "acntNoG长度不能超过40")
    @JSONField(name = "acnt_no_g")
    private String acntNoG;
    /**
     * 对公结算卡联行号
     * acnt_no_g填写后必传
     */
    @Length(max = 12, message = "interBankNoG长度不能超过12")
    @JSONField(name = "inter_bank_no_g")
    private String interBankNoG;
    /**
     * 对私结算卡
     * 对私清算、双账户清算必传
     * 对私结算户名默认为法人姓名
     */
    @Length(max = 40, message = "acntNoS长度不能超过40")
    @JSONField(name = "acnt_no_s")
    private String acntNoS;
    /**
     * 对私结算卡联行号
     * acnt_no_s填写后必传
     */
    @Length(max = 12, message = "interBankNoS长度不能超过12")
    @JSONField(name = "inter_bank_no_s")
    private String interBankNoS;
    /**
     * 入账人银行预留手机号
     */
    @Length(max = 11, message = "rzrTelephone长度不能超过11")
    @JSONField(name = "rzr_telephone")
    private String rzrTelephone;
    /**
     * 开户许可证编号
     */
    @Length(max = 24, message = "khxkzNo长度不能超过24")
    @JSONField(name = "khxkz_no")
    private String khxkzNo;

    /**
     * 受益人信息
     * 不参与签名
     */
    @NoSign
    @JSONField(name = "bene_infos")
    private List<FuiouFgjUpdateBeneRequest> beneInfos;

    /**
     * 股东信息
     * 不参与签名
     */
    @NoSign
    @JSONField(name = "shareholder_infos")
    private List<FuiouFgjShareholderRequest> shareholderInfos;


    /**
     * 分账扣率
     * 不开通，请误传值
     * 零扣请参照扣率代码表填写
     */
    @Length(max = 5, message = "fzSetCd长度不能超过5")
    @JSONField(name = "fz_set_cd")
    private String fzSetCd;
    /**
     * 商户充值扣率
     * 不开通，请误传值
     * 零扣请参照扣率代码表填写
     */
    @Length(max = 5, message = "merchantSetCd长度不能超过5")
    @JSONField(name = "merchant_set_cd")
    private String merchantSetCd;
    /**
     * 用户充值扣率
     * 不开通，请误传值
     * 零扣请参照扣率代码表填写
     */
    @Length(max = 5, message = "userSetCd长度不能超过5")
    @JSONField(name = "user_set_cd")
    private String userSetCd;
    /**
     * 银行账户收款扣率
     */
    @Length(max = 5, message = "bankCollectSetCd长度不能超过5")
    @JSONField(name = "bank_collect_set_cd")
    private String bankCollectSetCd;
    /**
     * 备注
     */
    @Length(max = 5, message = "remark长度不能超过5")
    @JSONField(name = "remark")
    private String remark;

    /**
     * 商户经营范围
     */
    @Length(max =128, message = "tradeDesc长度不能超128")
    @JSONField(name = "trade_desc")
    private String tradeDesc;

    /**
     * 业务场景描述
     */
    @Length(max =128, message = "businessDesc长度不能超128")
    @JSONField(name = "business_desc")
    private String businessDesc;

    /**
     * 归集扣率
     */
    @Length(max =5, message = "归集扣率长度不能超5")
    @JSONField(name = "gj_sett_cd")
    private String gjSettCd;

    /**
     * 商户结算扣率
     */
    @Length(max =5, message = "商户结算扣率长度不能超5")
    @JSONField(name = "js_sett_cd")
    private String jsSettCd;
    /**
     * 商户类别码
     */
    @Length(max =4, message = "商户类别码长度不能超4")
    @JSONField(name = "mchnt_mcc")
    private String mchntMcc;

}