/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.steward.component;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.core.util.XmlUtil;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.fuiou.util.LogUtil;
import com.fshows.fuiou.util.RsaUtils;
import com.fshows.fuiou.util.XmlConvertUtil;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.steward.apienum.FuStewardApiDefinitionEnum;
import com.fshows.steward.enums.FuStewardApiTypeEnum;
import com.fshows.steward.request.FuStewardBaseRequest;
import com.fshows.steward.response.FuStewardBaseResponse;
import com.fshows.steward.response.FuStewardBizResponse;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuStewardSerializableHandler
implements ISerializableHandler {
    private static final Logger log = LoggerFactory.getLogger(FuStewardSerializableHandler.class);

    public String serializeObject(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        if (!(requestContext.getIApiDefinition() instanceof FuStewardApiDefinitionEnum)) {
            throw new FsApiException("\u53c2\u6570\u5e8f\u5217\u5316\u5931\u8d25");
        }
        FuStewardApiDefinitionEnum apiDefinitionEnum = (FuStewardApiDefinitionEnum)requestContext.getIApiDefinition();
        if (FuStewardApiTypeEnum.ENCRYPT_API.equals((Object)apiDefinitionEnum.getApiTypeEnum())) {
            return this.encryptApiSerializeObject(apiRequestModel, requestContext);
        }
        return this.normalApiSerializeObject(apiRequestModel, requestContext);
    }

    private String normalApiSerializeObject(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        String xmlStr = FuiouRequestUtils.generateXmlByObjectMap(apiRequestModel.getParamMap());
        String enCodeStr = URLUtil.encodeAll((String)xmlStr, (Charset)CharsetUtil.CHARSET_GBK);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("req", enCodeStr);
        apiRequestModel.setRequestForm(params);
        return enCodeStr;
    }

    private String encryptApiSerializeObject(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        FuStewardBaseRequest request = (FuStewardBaseRequest)apiRequestModel.getRequest();
        DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
        String xmlStr = FuiouRequestUtils.generateXmlByObjectMap(apiRequestModel.getParamMap());
        LogUtil.info(log, "{} >> \u8bf7\u6c42\u53c2\u6570\u52a0\u5bc6 >> url={}, method={}, \u8bf7\u6c42\u660e\u6587xmlStr={}", requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), xmlStr);
        String encrypt = RsaUtils.encrypt(xmlStr, apiClientConfig.getPayCompanyPublicKey(), CharsetUtil.CHARSET_GBK);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mchntCd", request.getMchntCd());
        params.put("message", encrypt);
        apiRequestModel.setRequestForm(params);
        return null;
    }

    public IResponseDefinition deserializationResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        if (!(requestContext.getIApiDefinition() instanceof FuStewardApiDefinitionEnum)) {
            throw new FsApiException("\u53c2\u6570\u5e8f\u5217\u5316\u5931\u8d25");
        }
        FuStewardApiDefinitionEnum apiDefinitionEnum = (FuStewardApiDefinitionEnum)requestContext.getIApiDefinition();
        if (FuStewardApiTypeEnum.ENCRYPT_API.equals((Object)apiDefinitionEnum.getApiTypeEnum())) {
            return this.encryptApiDeserializationResponse(apiResponseModel, apiRequestModel, requestContext);
        }
        return this.normalApiDeserializationResponse(apiResponseModel, apiRequestModel, requestContext);
    }

    private IResponseDefinition normalApiDeserializationResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        String deCodeStr = null;
        try {
            FuStewardBaseResponse baseResponse = new FuStewardBaseResponse();
            deCodeStr = URLUtil.decode((String)apiResponseModel.getResponseBody(), (String)"GBK");
            FuStewardBizResponse bizResponse = (FuStewardBizResponse)XmlConvertUtil.xml2Bean(deCodeStr, requestContext.getIApiDefinition().getResponseClass());
            baseResponse.setData(bizResponse);
            baseResponse.setMchntCd(bizResponse.getMchntCd());
            apiResponseModel.setResponseSign(bizResponse.getSignature());
            apiResponseModel.setResponseMap(FuiouRequestUtils.ObjectToMap(bizResponse));
            return baseResponse;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk-fusteward\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> deCodeResBody={},  originalResBody={}", e, deCodeStr, apiResponseModel.getResponseBody());
            throw new FsApiException("[fuiou-sdk-fusteward]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
    }

    private IResponseDefinition encryptApiDeserializationResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        try {
            FuStewardBaseResponse baseResponse = new FuStewardBaseResponse();
            DefaultClientConfigModel configModel = requestContext.getApiClientConfig();
            Map resMap = XmlUtil.xmlToMap((String)apiResponseModel.getResponseBody());
            String mchntCd = resMap.get("mchntCd").toString();
            baseResponse.setMchntCd(mchntCd);
            Object messageObj = resMap.get("message");
            if (messageObj == null) {
                Object respDescObj = resMap.get("respDesc");
                if (respDescObj != null) {
                    throw new FsApiException("[fuiou-sdk-fusteward]\u5bcc\u53cb\u63a5\u53e3\u5904\u7406\u5f02\u5e38\uff1a" + respDescObj);
                }
                throw new FsApiException("[fuiou-sdk-fusteward]\u5bcc\u53cb\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a");
            }
            String encrypt = RsaUtils.decrypt(messageObj.toString(), configModel.getFubeiPrivateKey(), CharsetUtil.CHARSET_GBK);
            LogUtil.info(log, "{} >> \u54cd\u5e94\u7ed3\u679c\u89e3\u5bc6 >> url={}, method={}, \u54cd\u5e94\u5bc6\u6587={}, \u54cd\u5e94\u660e\u6587={}", requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), messageObj, encrypt);
            FuStewardBizResponse bizResponse = (FuStewardBizResponse)XmlConvertUtil.xml2Bean(encrypt, requestContext.getIApiDefinition().getResponseClass());
            apiResponseModel.setResponseSign(bizResponse.getSignature());
            apiResponseModel.setResponseMap(FuiouRequestUtils.ObjectToMap(bizResponse));
            baseResponse.setData(bizResponse);
            return baseResponse;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk-fusteward\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, apiResponseModel.getResponseBody());
            throw new FsApiException("[fuiou-sdk-fusteward]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
    }
}

