/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.steward.response.query;

import com.fshows.steward.response.FuStewardBizResponse;
import com.fshows.steward.response.query.item.FuStdTransferItemRes;
import lombok.Data;

import java.util.List;

/**
 * 用户间转账记账结果查询接口响应参数
 *
 * @author CodeBuddy
 * @version FuStdQuerySubAccountInTransferRes.java, v 0.1 2025-01-16 11:00
 */
@Data
public class FuStdQuerySubAccountInTransferRes extends FuStewardBizResponse {

    private static final long serialVersionUID = 5083693016986973153L;

    /**
     * 商户流水号
     */
    private String traceNo;

    /**
     * 富友批次号
     */
    private String batchNo;

    /**
     * 源交易商户流水号
     */
    private String mchntCdTraceNo;

    /**
     * 转出入账方编号
     */
    private String accountOut;

    /**
     * 批次返回码
     * 0000表示受理的子户转账异步处理完毕
     */
    private String batchRespCode;

    /**
     * 批次返回信息
     */
    private String batchRespDesc;

    /**
     * 转账明细列表
     */
    private List<FuStdTransferItemRes> items;
}