/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.response.trade.order;

import lombok.Data;
import lombok.EqualsAndHashCode;
import com.fshows.fuiou.response.base.FuiouBizResponse;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version FuiouOrderCloseResponse.java, v 0.1 2023-07-05 11:22:18
 */
@Data
public class FuiouOrderCloseResponse  extends FuiouBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555920401214L;


    /**
     * 商户号, 富友分配的商户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    private String mchntCd;

    /**
     * 终端号
     *
     * (选填)
     */
    @Length(max = 8, message = "termId长度不能超过8")
    private String termId;

    /**
     * 订单类型:ALIPAY，WECHAT，BESTPAY，UNIONPAY
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "orderType长度不能超过20")
    private String orderType;

    /**
     * 商户订单号, 商户系统内部的订单号 (5到30个字符、只能包含字母数字,区分大小写)
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntOrderNo长度不能超过30")
    private String mchntOrderNo;

}