/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.fuiou.client.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.IHttpRequest;
import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.client.base.ISigner;
import com.fshows.fuiou.client.base.SignParam;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.fuiou.util.LogUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * 富友交易接口客户端
 *
 * @author liluqing
 * @version TradeFuiouApiClientImpl.java, v 0.1 2022-03-04 15:02
 */
@Slf4j
public class TradeFuiouApiClientImpl extends AbstractFuiouApiClientImpl {

    public TradeFuiouApiClientImpl(ApiClientConfig apiClientConfig) throws FuiouApiException {
        super(apiClientConfig);
    }

    public TradeFuiouApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws FuiouApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends FuiouBizResponse, R extends IFuiouApiDefinition> T execute(FuiouBizRequest<T, R> request, R tradeApiDefinitionEnum) throws FuiouApiException {
        return (T) super.doExecute(request, tradeApiDefinitionEnum);
    }

    /**
     * 添加公共参数构建完整的请求
     *
     * @param bizRequest 业务请求参数
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected FuiouBizRequest buildFuiouBizRequest(FuiouBizRequest bizRequest, IFuiouApiDefinition tradeApiDefinitionEnum) {
        // 补充参数
        bizRequest.setInsCd(apiClientConfig.getAppId());
        bizRequest.setVersion(tradeApiDefinitionEnum.getVersion());
        bizRequest.setRandomStr(IdUtil.simpleUUID());
        return bizRequest;
    }

    @Override
    protected SignParam buildSignParam(FuiouBizRequest baseRequest) {
        SignParam signParam = new SignParam();
        signParam.setAppid(apiClientConfig.getAppId());
        signParam.setNonceStr(RandomUtil.randomString(12));
        signParam.setRequest(baseRequest);
        return signParam;
    }

    @Override
    protected String serializableRequest(FuiouBizRequest fuiouBaseRequest, String sign, IFuiouApiDefinition tradeApiDefinitionEnum) {
        Map<String, String> requstMap = FuiouRequestUtils.toMap(fuiouBaseRequest);
        return FuiouRequestUtils.generateXml(requstMap);
    }

    @Override
    protected FuiouBizResponse parseResponse(String resBody, IFuiouApiDefinition tradeApiDefinitionEnum) throws FuiouApiException {
        try {
            Map<String, String> resMap = FuiouRequestUtils.getMapFromXML(resBody);
            FuiouBizResponse fuiouBizResponse = FuiouRequestUtils.getObjectFromMap(resMap, tradeApiDefinitionEnum.getResponseClass());
            fuiouBizResponse.setResMap(resMap);
            return fuiouBizResponse;
        } catch (Exception e) {
            LogUtil.error(log, "【fuiou-sdk】响应结果反序列化异常 >> resBody={}", e, resBody);
            throw new FuiouApiException("[fuiou-sdk]响应结果反序列化异常");
        }
    }
}