/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.trade;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;

/**
 * 商户资金归集接口
 *
 * @author
 * @version FuStdMchntBalanceConcentrateRes.java, v 0.1 2024-01-02 16:35:47
 */
@Data
public class FuStdMchntBalanceConcentrateRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555860832682L;

    private Map<String, String> additionalFields = new HashMap<>();

    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 被归集商户号
     * 被归集的商户在富友的唯一代码
     * (必填)
     */
    @NotBlank
    private String mchntCdConcentrate;

    /**
     * 被归集金额
     * 分账金额，单位：分
     * (必填)
     */
    @NotNull
    private Integer amt;

    /**
     * 归集类型
     * 01：余额归集
02：转结资金归集
     * (必填)
     */
    @NotBlank
    private String concentrateType;

    /**
     * 富友批次号
     * 富友批次号
     * (选填)
     */
    private String batchNo;

    @JsonAnySetter
    public void addAdditionalField(String name, String value) {
        additionalFields.put(name, value);
    }

    @JsonAnyGetter
    public Map<String, String> getAdditionalFields() {
        return additionalFields;
    }
}