package com.fshows.steward.response.query.item;

/**
 * @author songjian * @version FuStdTransferItemRes.java, v 0.1 2025-09-16 11:20 songjian
 */

import com.fshows.steward.annotation.NoSign;
import lombok.Data;

import java.io.Serializable;

@Data
public class FuStdTransferItemRes implements Serializable {

    private static final long serialVersionUID = -4228493852433014697L;
    /**
     * 源交易商户子流水号
     * 商户子流水号
     */
    @NoSign
    private String mchntCdChildTraceNo;

    /**
     * 转入用户编号
     */
    @NoSign
    private String accountIn;

    /**
     * 转账金额
     * 单位：分
     */
    @NoSign
    private Integer amt;

    /**
     * 转账子流水号
     * 唯一流水号，商户定义
     */
    @NoSign
    private String transTraceNo;

    /**
     * 商户服务费金额
     */
    @NoSign
    private Integer fee;

    /**
     * 服务费子流水号
     * 唯一流水号，商户定义
     */
    @NoSign
    private String feeTraceNo;

    /**
     * 转入方结算卡号
     */
    @NoSign
    private String cardNo;

    /**
     * 分账状态
     * 枚举值：
     * 01 分账处理中
     * 05 分账成功
     * 06 分账失败
     */
    @NoSign
    private String status;

    /**
     * 结算状态
     * 枚举值：
     * 01 结算成功
     * 02 结算失败
     * 08 结算中
     * 09 已结算,状态未知
     * 07 银行退票
     */
    @NoSign
    private String allocateStatus;

    /**
     * 失败原因描述
     */
    @NoSign
    private String cleanDesc;

    /**
     * 转账交易参考号
     * 对账使用
     */
    @NoSign
    private String transferFasSsn;

    /**
     * 转账交易参考日期
     * 对账使用
     */
    @NoSign
    private String transferFasDate;

    /**
     * 转账交易返回码
     */
    @NoSign
    private String transferRespCode;

    /**
     * 转账交易返回描述
     */
    @NoSign
    private String transferRespDesc;

    /**
     * 服务费交易参考号
     * 对账使用
     */
    @NoSign
    private String feeFasSsn;

    /**
     * 服务费交易参考日期
     * 对账使用
     */
    @NoSign
    private String feeFasDate;

    /**
     * 服务费交易返回码
     */
    @NoSign
    private String feeRespCode;

    /**
     * 服务费交易返回描述
     */
    @NoSign
    private String feeRespDesc;

    /**
     * 自动结算交易参考号
     * 对账使用
     */
    @NoSign
    private String withDrawFasSsn;

    /**
     * 自动结算交易参考日期
     * 对账使用
     */
    @NoSign
    private String withDrawFasDate;

    /**
     * 自动结算交易返回码
     */
    @NoSign
    private String withDrawRespCode;

    /**
     * 自动结算交易返回描述
     */
    @NoSign
    private String withDrawRespDesc;

    /**
     * 附言
     */
    @NoSign
    private String remark;
}