/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.steward.annotation.NoSign;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 商户自有子账户创建接口
 *
 * @author
 * @version FuStdCreateSubAccountReq.java, v 0.1 2023-12-28 15:38:48
 */
@Data
public class FuStdCreateSubAccountReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555166834835L;


    /**
     * 交易流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 子户名称
     * 一个商户下此字段唯一
     * (必填)
     */
    @NotBlank
    @Length(max = 50, message = "subAccountName长度不能超过50")
    private String subAccountName;

    /**
     * 备注 1
     * 
     * (选填)
     */
    @Length(max = 50, message = "remark1长度不能超过50")
    @NoSign
    private String remark1;

    /**
     * 备注 2
     * 
     * (选填)
     */
    @Length(max = 50, message = "remark2长度不能超过50")
    @NoSign
    private String remark2;

}