/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fuiou.client.impl;

import cn.hutool.crypto.digest.MD5;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.fshows.fuiou.client.base.BankPayApiClientConfig;
import com.fshows.fuiou.client.base.FuiouHttpResult;
import com.fshows.fuiou.client.base.IFuiouBankPayApiDefinition;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.base.FuiouBankPayBizRequest;
import com.fshows.fuiou.response.base.FuiouBankPayBizResponse;
import com.fshows.fuiou.util.FsHttpUtil;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.fuiou.util.LogUtil;
import com.fshows.fuiou.util.ValidateUtil;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankPayTradeFuiouApiClientImpl {
    private static final Logger log = LoggerFactory.getLogger(BankPayTradeFuiouApiClientImpl.class);
    private BankPayApiClientConfig bankPayApiClientConfig;

    public BankPayTradeFuiouApiClientImpl(BankPayApiClientConfig bankPayApiClientConfig) throws FuiouApiException {
        ValidateUtil.validateWithThrow(bankPayApiClientConfig, new Class[0]);
        this.bankPayApiClientConfig = bankPayApiClientConfig;
    }

    protected FuiouBankPayBizResponse doExecute(FuiouBankPayBizRequest bizRequest, IFuiouBankPayApiDefinition tradeApiDefinitionEnum) throws FuiouApiException {
        try {
            this.checkParam(bizRequest, tradeApiDefinitionEnum);
            this.buildFuiouBizRequest(bizRequest);
            String url = this.getServerURL(tradeApiDefinitionEnum);
            FuiouHttpResult httpResult = this.requestGet(url, FuiouRequestUtils.toMap(bizRequest, true));
            FuiouBankPayBizResponse response = this.parseResponse(httpResult.getBody(), tradeApiDefinitionEnum);
            LogUtil.info(log, "\u3010fuiou-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u6620\u5c04\u7ed3\u675f >> url={}, request={}, response={}", url, bizRequest, response);
            return response;
        }
        catch (FuiouApiException e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011\u5bcc\u53cb\u8bf7\u6c42\u5f02\u5e38 >> tradeApiDefinition={}, bizRequest={}", e, tradeApiDefinitionEnum, bizRequest);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011\u5bcc\u53cb\u8bf7\u6c42\u5f02\u5e38 >> tradeApiDefinition={}, bizRequest={}", e, tradeApiDefinitionEnum, bizRequest);
            throw new FuiouApiException(e.getMessage(), e);
        }
    }

    protected FuiouHttpResult requestGet(String url, Map<String, String> paramMap) throws FuiouApiException {
        long beginTime = System.currentTimeMillis();
        try {
            LogUtil.info(log, "\u3010fuiou-sdk\u3011\u8bf7\u6c42\u5f00\u59cb >> url={}, paramMap={}", url, paramMap);
            String httpResult = FsHttpUtil.get(url, paramMap, this.bankPayApiClientConfig.getCharset(), null, this.bankPayApiClientConfig.getConnectionTimeout(), this.bankPayApiClientConfig.getReadTimeout(), null);
            if (StringUtils.isBlank((CharSequence)httpResult)) {
                throw new FuiouApiException("fuiou\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a");
            }
            FuiouHttpResult fuiouHttpResult = new FuiouHttpResult();
            fuiouHttpResult.setBody(URLDecoder.decode(httpResult, this.bankPayApiClientConfig.getCharset()));
            LogUtil.info(log, "\u3010fuiou-sdk\u3011\u8bf7\u6c42\u7ed3\u675f >> url={}, request={}, response={}, cost={}ms", url, paramMap, fuiouHttpResult.getBody(), System.currentTimeMillis() - beginTime);
            return fuiouHttpResult;
        }
        catch (FuiouApiException e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38 >> url={}, request={}, cost={}ms", e, url, paramMap, System.currentTimeMillis() - beginTime);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38 >> url={}, request={}, cost={}ms", e, url, paramMap, System.currentTimeMillis() - beginTime);
            throw new FuiouApiException("\u8bf7\u6c42fuiou\u63a5\u53e3\u5f02\u5e38", e);
        }
    }

    protected void checkParam(FuiouBankPayBizRequest bizRequest, IFuiouBankPayApiDefinition fuiouApiDefinition) throws FuiouApiException {
        ValidateUtil.notNull(bizRequest, "request\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        boolean checkRequestClass = StringUtils.equals((CharSequence)bizRequest.getClass().getCanonicalName(), (CharSequence)fuiouApiDefinition.getRequestClass().getCanonicalName());
        if (!checkRequestClass) {
            throw new FuiouApiException("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (this.bankPayApiClientConfig.isCheckParam()) {
            ValidateUtil.validateWithThrow(bizRequest, new Class[0]);
        }
    }

    protected String getServerURL(IFuiouBankPayApiDefinition tradeApiDefinitionEnum) {
        return this.bankPayApiClientConfig.getApiParentURL() + tradeApiDefinitionEnum.getApiSubURI();
    }

    protected FuiouBankPayBizRequest buildFuiouBizRequest(FuiouBankPayBizRequest bizRequest) {
        bizRequest.setRelateInsCd(this.bankPayApiClientConfig.getRelateInsCd());
        String signature = MD5.create().digestHex(bizRequest.getInOrderNo() + this.bankPayApiClientConfig.getSignatureKey());
        bizRequest.setSignature(signature);
        return bizRequest;
    }

    protected FuiouBankPayBizResponse parseResponse(String body, IFuiouBankPayApiDefinition tradeApiDefinitionEnum) throws FuiouApiException {
        try {
            JSONObject bodyJson = JSONObject.parseObject((String)body);
            Map resMap = (Map)JSONObject.parseObject((String)bodyJson.getString("data"), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            FuiouBankPayBizResponse bizResponse = (FuiouBankPayBizResponse)FuiouRequestUtils.getObjectFromMap(resMap, tradeApiDefinitionEnum.getResponseClass());
            bizResponse.setCode(bodyJson.getString("code"));
            bizResponse.setMsg(bodyJson.getString("msg"));
            bizResponse.setResMap(resMap);
            return bizResponse;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, body);
            throw new FuiouApiException("[fuiou-sdk]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
    }

    public <T extends FuiouBankPayBizResponse, R extends IFuiouBankPayApiDefinition> T execute(FuiouBankPayBizRequest<T, R> request, R tradeApiDefinitionEnum) throws FuiouApiException {
        return (T)this.doExecute(request, tradeApiDefinitionEnum);
    }
}

