/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 归集撤销接口
 *
 * @author
 * @version FuStdCancleConcentrateTradeReq.java, v 0.1 2024-01-02 16:38:11
 */
@Data
public class FuStdCancleConcentrateTradeReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555180878434L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 业务类型
     * 01 订单归集
02 资金归集
     * (必填)
     */
    @NotBlank
    @Length(max = 2, message = "busiType长度不能超过2")
    private String busiType;

    /**
     * 源归集交易富友批次号
     * 
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "srcBatchNo长度不能超过30")
    private String srcBatchNo;

    /**
     * 源归集交易金额
     * 
     * (必填)
     */
    @NotNull
    private Integer srcAmt;

}