/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.steward.request.query;

import com.fshows.steward.request.FuStewardBizRequest;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 用户间转账记账结果查询接口请求参数
 *
 * @author CodeBuddy
 * @version FuStdQuerySubAccountInTransferReq.java, v 0.1 2025-01-16 11:00
 */
@Data
public class FuStdQuerySubAccountInTransferReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -6998652196611819845L;

    /**
     * 商户流水号 (必填参数)
     * 唯一流水号，商户定义
     */
    @NotBlank(message = "商户流水号不能为空")
    @Size(max = 30, message = "商户流水号长度不能超过30")
    private String traceNo;

    /**
     * 源交易商户流水号 (可选参数)
     * 商户流水号查批次，与mchntCdChildTraceNo至少传一个
     */
    @Size(max = 30, message = "源交易商户流水号长度不能超过30")
    private String mchntCdTraceNo;

    /**
     * 源交易商户子流水号 (可选参数)
     * 商户子流水号查单笔，与mchntCdTraceNo至少传一个
     */
    @Size(max = 30, message = "源交易商户子流水号长度不能超过30")
    private String mchntCdChildTraceNo;
}