/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.steward.request.query;

import com.fshows.steward.annotation.NoSign;
import com.fshows.steward.request.FuStewardBizRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * @author wangqilei
 * @version FuStdQueryAllocateAccountReq.java, v 0.1 2024-03-21 4:03 PM wangqilei
 */
@Data
public class FuStdQueryAllocateAccountReq extends FuStewardBizRequest {
    private static final long serialVersionUID = -8306515832872123982L;

    /**
     * 商户流水号
     */
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 开户请求流水号
     */
    @Length(max = 30, message = "mchntTraceNo长度不能超过30")
    @NoSign
    private String mchntTraceNo;

    /**
     * 户名
     */
    @Length(max = 128, message = "outAcntNm长度不能超过128")
    private String outAcntNm;

    /**
     * 手机号码
     */
    @Length(max = 20, message = "mobile长度不能超过20")
    private String mobile;

    /**
     * 银行账号
     */
    @Length(max = 40, message = "outAcntNo长度不能超过40")
    private String outAcntNo;

    /**
     * 用户编号
     */
    @Length(max = 30, message = "accountIn长度不能超过30")
    private String accountIn;

    /**
     * 证件号
     */
    @Length(max = 20, message = "idNo长度不能超过20")
    @NoSign
    private String idNo;
}