/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.account;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 归集关系取消接口
 *
 * @author
 * @version FuStdCancleConcentrateRelationReq.java, v 0.1 2023-12-28 15:55:29
 */
@Data
public class FuStdCancleConcentrateRelationReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555407665573L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 被归集商户号
     * 被归集商户在富友的唯一代码
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntCdConcentrate长度不能超过30")
    private String mchntCdConcentrate;

}