/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.client.base.IHttpRequest;
import com.fshows.fuiou.client.base.ISigner;
import com.fshows.fuiou.client.base.SignParam;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import lombok.extern.slf4j.Slf4j;

/**
 * @author zhubo
 * @version MerchantFuiouApiJsonClientImpl.java, v 0.1 2023-09-18 14:12 zhubo
 */
@Slf4j
public class MerchantFuiouApiJsonClientImpl extends AbstractFuiouApiClientImpl {
    public MerchantFuiouApiJsonClientImpl(ApiClientConfig apiClientConfig) throws FuiouApiException {
        super(apiClientConfig, new DefaultHttpRequestImpl(), new MerchantSignerImpl());
    }

    public MerchantFuiouApiJsonClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws FuiouApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends FuiouBizResponse, R extends IFuiouApiDefinition> T execute(FuiouBizRequest<T, R> request, R merchantApiDefinitionEnum) throws FuiouApiException {
        return (T) super.doExecute(request, merchantApiDefinitionEnum);
    }

    @Override
    protected FuiouBizRequest buildFuiouBizRequest(FuiouBizRequest request, IFuiouApiDefinition merchantApiDefinitionEnum) {
        // 补充参数
        request.setInsCd(apiClientConfig.getAppId());
        return request;
    }

    @Override
    protected SignParam buildSignParam(FuiouBizRequest baseRequest) {
        SignParam signParam = new SignParam();
        signParam.setAppid(apiClientConfig.getAppId());
        signParam.setNonceStr(RandomUtil.randomString(12));
        signParam.setRequest(baseRequest);
        return signParam;
    }

    @Override
    protected String serializableRequest(FuiouBizRequest fuiouBaseRequest, String sign, IFuiouApiDefinition merchantApiDefinitionEnum) {
        return JSONObject.toJSONString(fuiouBaseRequest);
    }

    @Override
    protected FuiouBizResponse parseResponse(String body, IFuiouApiDefinition merchantApiDefinitionEnum) {
        return JSONObject.parseObject(body, merchantApiDefinitionEnum.getResponseClass());
    }
}
