/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fuiou.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.client.base.IHttpRequest;
import com.fshows.fuiou.client.base.ISigner;
import com.fshows.fuiou.client.base.SignParam;
import com.fshows.fuiou.client.impl.AbstractFuiouApiClientImpl;
import com.fshows.fuiou.client.impl.DefaultHttpRequestImpl;
import com.fshows.fuiou.client.impl.MerchantSignerImpl;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.fuiou.util.LogUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MerchantFuiouApiXmlClientImpl
extends AbstractFuiouApiClientImpl {
    private static final Logger log = LoggerFactory.getLogger(MerchantFuiouApiXmlClientImpl.class);

    public MerchantFuiouApiXmlClientImpl(ApiClientConfig apiClientConfig) throws FuiouApiException {
        super(apiClientConfig, new DefaultHttpRequestImpl(), new MerchantSignerImpl());
    }

    public MerchantFuiouApiXmlClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws FuiouApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends FuiouBizResponse, R extends IFuiouApiDefinition> T execute(FuiouBizRequest<T, R> request, R merchantApiDefinitionEnum) throws FuiouApiException {
        return (T)super.doExecute(request, merchantApiDefinitionEnum);
    }

    @Override
    protected FuiouBizRequest buildFuiouBizRequest(FuiouBizRequest request, IFuiouApiDefinition tradeApiDefinitionEnum) {
        request.setInsCd(this.apiClientConfig.getAppId());
        return request;
    }

    @Override
    protected SignParam buildSignParam(FuiouBizRequest baseRequest) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setNonceStr(RandomUtil.randomString((int)12));
        signParam.setRequest(baseRequest);
        return signParam;
    }

    @Override
    protected String serializableRequest(FuiouBizRequest fuiouBaseRequest, String sign, IFuiouApiDefinition tradeApiDefinitionEnum) {
        Map<String, String> requstMap = FuiouRequestUtils.toMap(fuiouBaseRequest);
        return FuiouRequestUtils.generateXml(requstMap);
    }

    @Override
    protected FuiouBizResponse parseResponse(String resBody, IFuiouApiDefinition merchantApiDefinitionEnum) throws FuiouApiException {
        try {
            Map<String, String> resMap = FuiouRequestUtils.getMapFromXML(resBody);
            FuiouBizResponse fuiouBizResponse = (FuiouBizResponse)FuiouRequestUtils.getObjectFromMap(resMap, merchantApiDefinitionEnum.getResponseClass());
            fuiouBizResponse.setResMap(resMap);
            return fuiouBizResponse;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, resBody);
            throw new FuiouApiException("[fuiou-sdk]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
    }
}

